<?php
  if(!isset($_SESSION)){
	session_start();
  }
  
  
  include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php");
  
  if(isset($loggedIn) && $loggedIn === true){
	require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.brdata.inc.php");
	$brdataObj = new brdata();
	$theUser = $brdataObj->getUser($_SESSION['FrequentShopperNum']);
	
	require_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.rewards.inc.php");
	$rewardsUserObj = new rewards($theUser['Phone']);
	//$rewardsUserObj->preferredStore = $theUser['MyStore']['MyStoreNumber'];
	
	$rewardsReceipts = $rewardsUserObj->getUserOrderSummary();
	
	list($userCredit, $userPoints, $accountError) = $rewardsUserObj->getUserCreditPoints($theUser['Phone']);
	
	list($personalOffers, $commonOffers) = $rewardsUserObj->getAccountPromotions();
	$availableCharities = $brdataObj->getCharities($_SESSION['FrequentShopperNum']);
	$userCharities = $brdataObj->getUserCharities($_SESSION['FrequentShopperNum']);
  }else{
	header("Location: https://" . $_SERVER['SERVER_NAME'] . "/about-rewards");
  }
  $theError = false;
  
?>
<?php
  $pageTitle = "User Information";
  $pageDescription = "Your user information";
  $pageKeywords = "";

  $theSiteParts = explode(".", $_SERVER['HTTP_HOST']);
  $theSite = $theSiteParts[0];
  $theSite = 'stokesmarket';
?>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
?>

<script src="/Kickstrap/js/jquery-ui-1.9.0.custom.min.js"></script>
<link href="/Kickstrap/css/smoothness/jquery-ui-1.9.0.custom.css" rel="stylesheet">
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.18/r-2.2.2/rg-1.0.3/datatables.min.js">
</script>
<link rel="stylesheet" type="text/css"
    href="https://cdn.datatables.net/v/dt/dt-1.10.18/r-2.2.2/rg-1.0.3/datatables.min.css" />



<style>
body #contentWrapper #sf-wrapper #bodyPadding #trueContentWrapper #mainContent .span12 {
    width: 95%;
}

.control-label {
    font-weight: 900;
}

.controls,
.control-label {
    display: inline;
}

.hideObject {
    display: none !important;
}

@media (max-width: 780px) {
    #changePWcontain label {
        display: block;
    }
}

#mainContent .well {
    margin-right: 1.5%;
    width: 27.5%;
}

@media (max-width: 780px) {
    #mainContent .well {
        margin-right: auto;
        width: 100%;
    }
}
</style>
<link href="/css/circle.css" rel="stylesheet" type="text/css" />

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php'); ?>

<section class="container">
    <div id="blankBuffer"></div>
    <section class="row" id="<?php echo isset($theUser) ? 'rewardsContent' : 'mainContent'; ?>">
        <div class="span12">
            <img src="/Kickstrap/img/StokesRewardsLogo-01.png" width="150" alt="Perks Logo" class="floatLeftImg">
            <h1>Welcome to Rewards</h1>
            <p>Do you love getting rewarded? Good news! With your Rewards membership you'll have access to benefits
                like: earning free groceries with each dollar you spend, exclusive offers and bonus gifts, a carton of
                ice cream for your birthday, hundreds of digital coupons, weekly sale alerts, yummy recipes and more!
                We're thrilled you're now a Rewards member!</p>
            <div style="clear:both;"></div>
            <div id="rewardsNavigation" class="tabbable">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#rewardsPerks" data-toggle="tab"><i class="icon-home"></i> Rewards</a>
                    </li>
                    <li id="schoolCentsNav">
                        <a href="#rewardsSC" data-toggle="tab">
                            <svg version="1.1" id="schoolBus" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="200px" height="200px"
                                viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
                                <g>
                                    <g>
                                        <g>
                                            <path class="st0"
                                                d="M184.6,24.6c-2.8-7.5-8.5-9.8-8.5-9.8c-22.3-5.2-67.7-6.5-67.7-6.5C36.1,5.5,33.1,22.9,33.1,22.9
											C2.3,88.5,6.9,156.6,7.9,164.6c1.1,8,7.2,9.8,7.2,9.8c3.6,0.7,7.4,1.4,11.4,1.9c0.2-3.4,1.3-6.5,3.4-9.1c2.9-3.5,7.1-5.4,12-5.4
											l0.1,0c4.7,0,9.4,1.9,13.3,5.2c3.9,3.3,6.5,7.7,7.3,12.4c0,0.1,0,0.2,0,0.3c28.2,1.5,58,1.1,79.9,0.3c-0.6-4.6,0.5-8.9,3.3-12.2
											c2.9-3.5,7.1-5.4,12-5.4l0.1,0c11,0.1,17.1,2.4,20.1,14.8c7.6-2.4,8.3-7,8.3-7C200.7,87,187.4,32,184.6,24.6z M20.6,103.8
											c-8-0.3-6.5-11.2-6.5-11.2c1.2-13.4,16.3-60.9,21.1-64.7c3.3-2.6,3.4,3.5,3.4,3.5C37.5,112.6,28.6,104.2,20.6,103.8z" />
                                        </g>
                                    </g>
                                    <g>
                                        <g>
                                            <path class="st0" d="M175.8,180.5c-2.3-12.7-6.7-15-17.7-15.1l-0.1,0c-3.9,0-7.4,1.5-9.7,4.3c-2.4,2.8-3.3,6.6-2.5,10.7
											c1.5,8.3,9.5,15,17.7,15.1l0.1,0c3.9,0,7.4-1.5,9.7-4.3C175.6,188.4,176.5,184.6,175.8,180.5z M162.8,189.8c-4.6,0-9-3.8-9.8-8.4
											c-0.8-4.6,2.2-8.3,6.8-8.2c4.6,0,9,3.8,9.8,8.4C170.4,186.1,167.3,189.8,162.8,189.8z" />
                                        </g>
                                    </g>
                                    <g>
                                        <g>
                                            <path class="st0" d="M59.7,180c-1.5-8.3-9.5-15-17.7-15.1l-0.1,0c-3.9,0-7.4,1.5-9.7,4.3c-2.4,2.8-3.3,6.6-2.5,10.7
											c1.5,8.3,9.5,15,17.7,15.1l0.1,0c3.9,0,7.4-1.5,9.7-4.3C59.6,187.8,60.5,184,59.7,180z M46.6,188.4c-4.6,0-9-3.8-9.8-8.4
											c-0.8-4.6,2.2-8.3,6.8-8.2c4.6,0,9,3.8,9.8,8.4C54.2,184.7,51.2,188.4,46.6,188.4z" />
                                        </g>
                                    </g>
                                    <g>
                                        <g>
                                            <path class="st1" d="M178.8,89.6c-0.5-6.1-5.9-11.1-12-11.1l-113-0.8c-6.1,0-11.6,4.9-12.2,10.9c0,0-2,20.1-2.1,38.6
											c-0.1,18.5,1.3,30.6,1.3,30.6c0.2,1.4,0.6,2.8,1.3,4.1c4.7,0,9.4,1.9,13.3,5.2c0.7,0.6,1.3,1.2,1.9,1.9l87.4,0.6
											c0.4-0.6,0.8-1.2,1.2-1.8c2.9-3.5,7.1-5.4,12-5.4l0.1,0c7,0.1,11.9,1,15.4,4.8c2.6-2,4.5-5.1,4.8-8.5c0,0,1.7-19.7,1.8-36
											C180.2,106.5,178.8,89.6,178.8,89.6z" />
                                        </g>
                                    </g>
                                </g>
                            </svg>


                            School Cents
                        </a>
                    </li>
                    <li>
                        <a href="#rewardsAbout" data-toggle="tab"><i class="icon-question-sign"></i> About Rewards</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane span12" id="rewardsAbout">
                        <?php include("https://afsshareportal.com/siteContent/corporate/perks-about.php?theSite=" . $theSite . "&page=rewards"); ?>
                    </div>
                    <div class="tab-pane span12" id="rewardsSC">
                        <img src="https://afsshareportal.com/Kickstrap/img/ARO/schoolCents/SchoolCentsWebanner_generic.jpg"
                            width="100%" alt="School Cents Banner" style="margin-bottom: 30px;">
                        <div class="span8" id="charityChangeContain">
                            <p class="alert alert-success hideObject" id="charitySuccess">You have updated your charity!
                            </p>
                            <h2>Your School: </h2>
                            <h4 id="charityName"><?php echo explode('_', $userCharities['Description'])[0]; ?></h4>
                            <hr>
                            <?php
							if($availableCharities !== false){
						?>
                            <p>Choose one of the schools below to update:</p>
                            <div class="controls">
                                <table class="table stripe" id="charityTable" style="width:100%">
                                    <thead>
                                        <tr>
                                            <td></td>
                                            <td>School Name</td>
                                            <td>School District</td>
                                            <td>Zip Code</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
								foreach ($availableCharities as $key => $cityGroup) {
						?>
                                        <?php
									foreach ($cityGroup as $charity) {
										$charity = (array) $charity;
						?>
                                        <tr id="<?php echo $charity['id']; ?>">
                                            <td>
                                                <label class="radio" for="charityradios-<?php echo $charity['id']; ?>">
                                                    <input type="radio" name="charityradios"
                                                        id="charityradios-<?php echo $charity['id']; ?>"
                                                        value="<?php echo $charity['id']; ?>" class="charityOption">
                                                </label>
                                            </td>
                                            <td><?php echo $charity['name']; ?></td>
                                            <td><?php echo $key; ?></td>
                                            <td><?php echo $charity['zip']; ?></td>
                                        </tr>


                                        <?php
									}
								}
						?>
                                    </tbody>
                                </table>
                            </div>

                            <br>

                            <a href="#" id="updateCharityBtn" class="btn btn-large btn-primary hideObject">Update your
                                school</a>
                            <?php
							}
						?>
                        </div>

                        <div class="span4">
                            <h2>About School Cents</h2>
                            <p>We know that nothing is more important to a child's future than education. Select your
                                local school to contribute a small portion of your purchase to your child's school.</p>
                            <a href="/school-cents" class="btn btn-primary btn-large">Learn More About School Cents</a>
                        </div>





                    </div>
                    <div class="tab-pane span12 active" id="rewardsPerks">
                        <div class="span5 ml-0 well sameSize1" id="walletCreditsContainer">
                            <h3>Rewards Points
                                <i class="icon-question-sign tooltip" id="pointsModalLabel" data-toggle="tooltip"
                                    data-placement="bottom" title="" data-original-title="Click for more information"
                                    data-container="#pointsModal"></i>
                            </h3>

                            <div id="creditsContainer" class="big">
                                <?php
						  
						  //$userPoints['Balance'] = "423.0000";
						  $userPoints['Balance'] = (float) $userPoints['Balance'];

						  $minPoints = 40;
						  
						  $earnedTotal = floor($userPoints['Balance'] / 100) * 10;
						  $potentialTotal = (($userPoints['Balance'] / 1000) * 100);
						  $earnedTotalCeil = ceil($userPoints['Balance'] / 100) * 10;
						  
						  if($earnedTotal < $minPoints){
							$earnedTotal = 0;
							$earnedTotalCeil = $minPoints;
						  }else if($earnedTotal >100){
							$earnedTotal = 100;
							$earnedTotalCeil = 100;
							$potentialTotal = 100;
						  }
						?>

                                <div
                                    class="c100 p<?php echo !is_null($earnedTotal) ? number_format($earnedTotal) : 0; ?> s<?php echo !is_null($potentialTotal) ? number_format($potentialTotal) : 0; ?> t<?php echo !is_null($earnedTotalCeil) ? number_format($earnedTotalCeil) : 0; ?> big">
                                    <span class="pointsContainer">
                                        <span class="pointsBanked"><b>$<?php echo !is_null($earnedTotal) ? number_format($earnedTotal / 10) : 0; ?>
                                                Earned</b><br><small>for next month</small></span>
                                        <span
                                            class="pointsNeeded"><?php echo (!is_null($earnedTotalCeil) || !is_null($userPoints['Balance'])) ? number_format(($earnedTotalCeil - $potentialTotal) * 10) : 0; ?>
                                            Points Needed <br><small>for next reward</small></span>
                                        <span
                                            class="pointsTotal"><?php echo !is_null($userPoints['Balance']) ? number_format($userPoints['Balance']) : 0; ?>
                                            Points <br> Earned</span>
                                    </span>
                                    <div class="slice3">
                                        <div class="bar3"></div>
                                        <div class="fill3"></div>
                                    </div>
                                    <div class="slice2">
                                        <div class="bar2"></div>
                                        <div class="fill2"></div>
                                    </div>
                                    <div class="slice">
                                        <div class="bar"></div>
                                        <div class="fill"></div>
                                    </div>

                                </div>

                                <div id="pointsModal" class="modal hide fade" tabindex="-1" role="dialog"
                                    aria-labelledby="pointsModalLabel" aria-hidden="true">
                                    <div class="modal-body">
                                        <h2>Understanding Rewards Points</h2>
                                        <p>Earn 1 Reward point for every $1 spent. Points are earned monthly and on the
                                            first of each month an instore credit will be issued to your Rewards
                                            accounts based on how many points you earned. During checkout use your
                                            Rewards phone number to earn points on every shopping trip!</p>
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <td>Points</td>
                                                    <td>Wallet Credit</td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>400-499</td>
                                                    <td>$4</td>
                                                </tr>
                                                <tr>
                                                    <td>500-599</td>
                                                    <td>$5</td>
                                                </tr>
                                                <tr>
                                                    <td>600-699</td>
                                                    <td>$6</td>
                                                </tr>
                                                <tr>
                                                    <td>700-799</td>
                                                    <td>$7</td>
                                                </tr>
                                                <tr>
                                                    <td>800-899</td>
                                                    <td>$8</td>
                                                </tr>
                                                <tr>
                                                    <td>900-999</td>
                                                    <td>$9</td>
                                                </tr>
                                                <tr>
                                                    <td>1000+</td>
                                                    <td>$10</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
                                    </div>
                                </div>

                            </div>

                            <div style="clear: both;"></div>

                            <div id="walletEarnedContain">
                                <p><b>Available Wallet Credits</b></p>
                                <h4><span
                                        class="walletEarned">$<?php echo number_format($userCredit['Balance'], 2); ?></span>
                                </h4>

                                <hr>

                                <p class="small">All wallet credits expire at the end of the month</p>
                            </div>

                        </div>

                        <div class="span7 well sameSize1">
                            <h3>Level Up With Rewards</h3>
                            <div>
                                We've partnered with many of the brands you know and love to offer you
                                special savings
                                on the products you frequently buy.
                                We are offering you free items or bonus savings after you've bought a
                                certain number of
                                products. Level up today, shop
                                these special buys and earn free product.
                            </div>
                            <br>
                            <?php
						if(!is_null($personalOffers)){
						  foreach($personalOffers as $offer){
					  ?>
                            <div class="oneOffer" id="personalPromo_<?php echo $offer->id; ?>">
                                <h4>
                                    <?php echo $offer->headline; ?>
                                    <span class="pull-right">
                                        <?php
								if($offer->percentComplete == '100'){
							  ?>
                                        <span class="redeemNow">Redeem Now</span>
                                        <?php
								}else{
							  ?>
                                        <?php echo $offer->percentComplete; ?>%
                                        <?php
								}
							  ?>
                                    </span>
                                </h4>
                                <div class="progress">
                                    <div class="bar <?php echo $offer->percentComplete == '100' ? 'bar-success' : 'bar-primary'; ?>"
                                        style="width: <?php echo $offer->percentComplete; ?>%;"></div>
                                </div>
                                <div class="width-100 ml-0">
                                    <p class="offerDescription pull-left">
                                        <?php echo $offer->description; ?>
                                    </p>
                                    <p class="offerExpiration pull-right">
                                        exp. <?php echo $offer->expires; ?> <br>
                                        <a href="#" class="learnMoreReveal">Learn More <i class="icon-play"></i></a>
                                    </p>
                                    <p class="offerDescriptionFull hideObject">
                                        <?php echo $offer->limit; ?> <br>
                                        <?php echo $offer->restrictions; ?>
                                    </p>
                                </div>
                            </div>
                            <div style="clear: both;"></div>
                            <?php
						  }
						}else{
					  ?>
                            <h4>There are no current Perks Offers.</h4>
                            <?php
						}
					  ?>
                        </div>


                        <div class="span100 well ml-0" id="couponsInfoContainer">
                            <h3>Instant Savings</h3>
                            <div>
                                Unlike digital coupons where you need to clip them to your account, we
                                want to say thank
                                you with these great deals just
                                for being a rewards member. Our instant savings offers are loaded
                                automatically to your
                                account to make it easy to save money
                                at the checkout or when shopping online.
                            </div>
                        </div>

                        <div class="ml-0 mb-30 clearfix" id="allCouponsContainer">
                            <!--<p class="span12">Enjoy these pre-loaded deals that you can simply redeem at checkout using your rewards phone number.</p>-->
                            <div class="span71 ml-0">

                                <?php
						  //$couponSearchInfo = [];
						  
							if(!is_null($commonOffers)){
							  foreach($commonOffers as $coupon){
								// $couponSearchInfo[] = (object) [
								//   "value" => $coupon->product,
								//   "id" => $coupon->id
								// ];
						?>
                                <div class="oneCoupon" id="coupon_<?php echo $coupon->id; ?>"
                                    data-restrictions="<?php echo !is_null($coupon->restrictions) ? $coupon->restrictions : "No restrictions"; ?>"
                                    data-expires="<?php echo $coupon->expires; ?>"
                                    data-expiressort="<?php echo $coupon->expiresSort; ?>">
                                    <i class="icon-question-sign tooltip" data-toggle="tooltip" data-placement="bottom"
                                        title="" data-original-title="Click for more information"
                                        data-container="#coupon_<?php echo $coupon->id; ?>"></i>


                                    <div class="imageContain">
                                        <?php
									if(!is_null($coupon->image)){
								  ?>
                                        <img src="<?php echo $coupon->image; ?>" class="couponImage"
                                            alt="<?php echo $coupon->product; ?>" width="100%">
                                        <?php
									}else{
								  ?>
                                        &nbsp;
                                        <?php
									}
								  ?>
                                    </div>

                                    <div class="couponInformation">
                                        <div class="couponContent">
                                            <h4 class="couponHeadline"><?php echo $coupon->offer; ?></h4>
                                            <p class="couponDescription"
                                                data-full-description="<?php echo $coupon->description; ?>">
                                                <?php echo $coupon->shortDesc; ?>
                                                <br>
                                                <?php echo $coupon->expires; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php
							}
						  }else{
						?>
                                <h4 class="span12">There are no current coupons</h4>
                                <?php
						  }

						  if($rewardsUserObj->error !== false){
						?>
                                <p class="hideObject" id="rewardsErrorMsg"><?php echo $rewardsUserObj->error; ?></p>
                                <?php
						  }
						?>
                            </div>
                        </div>

                        <div id="couponModal" class="modal hide fade" tabindex="-1" role="dialog"
                            aria-labelledby="couponModalLabel" aria-hidden="true">
                            <div class="modal-body">
                                <div class="oneCoupon">
                                    <div class="imageContain">
                                        <img src="" class="couponImage" width="100%">
                                    </div>

                                    <div class="couponInformation">
                                        <div class="couponContent">
                                            <h4 class="couponOffer couponClear"></h4>
                                            <p class="couponDescription couponClear"></p>
                                            <h6>Restrictions:</h6>
                                            <p class="couponRestrictions couponClear"></p>
                                            <h6>Expires:</h6>
                                            <p class="couponExpires couponClear"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div style="clear: both; margin-bottom: 60px;"></div>
        </div>
    </section>
</section>

<script type="text/javascript">
$(document).ready(function() {
    $(".tooltip").tooltip();

    $(".accordion-heading a").on('click', function() {
        $(".accordion-heading").removeClass("viewed");
        var $this = $(this);
        var $aHeading = $this.parents(".accordion-heading");
        setTimeout(function() {
            if ($aHeading.siblings(".accordion-body").is(".in")) {
                $aHeading.addClass("viewed");
            }
        }, 50);
    });

    $(".charityOption").on('touch click', function() {
        $("#updateCharityBtn").removeClass("hideObject");
        $('html, body').animate({
            scrollTop: $("#updateCharityBtn").offset().top - 100
        }, 2000);
    });

    $("#updateCharityBtn").on('touch click', function(e) {
        e.preventDefault();

        var id = $('input[type=radio][name=charityradios]:checked').attr('id').replace("charityradios-",
            "");

        $.ajax({
            type: "POST",
            url: "/admin/lookUp.php",
            data: "action=changeBrCharity&charity=" + id,
            dataType: "json",
            success: function(theResponse) {
                if (theResponse.success === true) {
                    var schoolName = theResponse.charity.Description.split("_")[0];
                    $("#charitySuccess").removeClass("hideObject");
                    $("#charityName").text(schoolName);

                    $('html, body').animate({
                        scrollTop: $("#charityChangeContain").offset().top
                    }, 2000);

                    setTimeout(function() {
                        $("#charitySuccess").addClass("hideObject");
                    }, 5000);
                }
            }
        });
    });

    $("body").on("click touch", "#walletCreditsContainer .icon-question-sign", function(e) {
        e.preventDefault();

        $("#pointsModal").modal("show");
    });

    $("body").on("click touch", "#allCouponsContainer .oneCoupon .icon-question-sign", function(e) {
        e.preventDefault();
        var $this = $(this).closest('.oneCoupon');

        $("#couponModal .couponImage").attr("src", $this.find(".couponImage").attr("src"));
        $("#couponModal .couponOffer").html($this.find(".couponContent .couponHeadline").html());
        $("#couponModal .couponDescription").html($this.find(".couponContent .couponDescription").data(
            "full-description"));
        $("#couponModal .couponRestrictions").html($this.data("restrictions"));
        $("#couponModal .couponExpires").html($this.data("expires"));

        $("#couponModal").modal("show");
    });

    $("#couponModal").on('hidden.bs.modal', function() {
        $this = $(this);
        $(".couponImage", $this).attr("src", "");
        $(".couponClear").html("");
    })

    $(".learnMoreReveal").on("click touch", function(e) {
        e.preventDefault();
        $(this).closest(".oneOffer").find(".offerDescriptionFull").toggleClass("hideObject");
    });

    var maxHeight = -1;
    $('.sameSize1').each(function() {
        maxHeight = maxHeight > $(this).height() ? maxHeight : $(this).height();
    });

    $('.sameSize1').height(maxHeight);

    /*
    myAutocompleteCoupon(<?php echo json_encode($couponSearchInfo); ?>)
    /*
		myAutocompleteCoupon(<?php echo json_encode($couponSearchInfo); ?>)
		
		function myAutocompleteCoupon(theCouponNames){
		  if($("#couponSearch").val() != "undefined"){
			searchVal = $("#couponSearch").val();
			
			if(searchVal != ""){
			  $("#couponSearch").val("");	
			}
			
			$("#couponSearch").autocomplete({
			  minLength: 0,
			  position: { my : "right top", at: "right bottom" },
			  source: theCouponNames,
			  focus: function( event, ui ) {
				$( "#couponSearch" ).val( ui.item.label );
				return false;
			  }
			});
			
			$("#couponSearch").on( "autocompleteresponse", function( event, ui ) {
			  if (ui.content.length > 0) {
				$("#allCouponsContainer .oneCoupon").addClass('hideObject');
			  }else {
				$("#allCouponsContainer .oneCoupon").removeClass('hideObject');
			  }
			  
			  $.each(ui.content, function(index, value){
				$("#coupon_" + value.id).removeClass('hideObject');
			  });
			});
		  }	
		}
		*/
    function myAutocompleteCoupon(theCouponNames){
      if($("#couponSearch").val() != "undefined"){
    	searchVal = $("#couponSearch").val();
    	
    	if(searchVal != ""){
    	  $("#couponSearch").val("");	
    	}
    	
    	$("#couponSearch").autocomplete({
    	  minLength: 0,
    	  position: { my : "right top", at: "right bottom" },
    	  source: theCouponNames,
    	  focus: function( event, ui ) {
    		$( "#couponSearch" ).val( ui.item.label );
    		return false;
    	  }
    	});
    	
    	$("#couponSearch").on( "autocompleteresponse", function( event, ui ) {
    	  if (ui.content.length > 0) {
    		$("#allCouponsContainer .oneCoupon").addClass('hideObject');
    	  }else {
    		$("#allCouponsContainer .oneCoupon").removeClass('hideObject');
    	  }
    	  
    	  $.each(ui.content, function(index, value){
    		$("#coupon_" + value.id).removeClass('hideObject');
    	  });
    	});
      }	
    }
    */

    $("#couponsSort").on("change", function() {
        var direction = $("option:selected", this).val();

        var divList = $("#allCouponsContainer .oneCoupon");
        if (direction === "old") {
            divList.sort(function(a, b) {
                return $(b).data("expiressort") - $(a).data("expiressort");
            });
        } else {
            divList.sort(function(a, b) {
                return $(a).data("expiressort") - $(b).data("expiressort");
            });
        }

        $("#allCouponsContainer").html(divList);
    });



    //Receipts Code
    $(".receiptLink").on("touch click", function(e) {
        e.preventDefault();

        var id = $(this).closest('.receiptLinkContainer').attr('id').replace('receiptLink_', '');
        $("#rewardsContentContainer .oneReceipt").addClass("hideObject");
        $("#fullReceipt_" + id).removeClass("hideObject");
    });

    $("#charityTable").DataTable({
        "order": [
            [2, "asc"]
        ],
        paging: false
    });
});
</script>

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>