<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php") ?>
<?php
  $pageTitle = "Produce Glossary";
  $pageDescription = "Learn how to store and take care of all of your produce. We even have recipes for each produce item.";
  $pageKeywords = "produce, cooking, storage, picking";
?>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
?>

<style>
	  #mainContent .row .span12{
			width: 95%;
	  }
	  
	  
	  
	  /*TAKE THESE TO BOOTSTRAP.LESS*/
	  
	  
	  
</style>

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php'); ?>

<?php
	  
	  if(isset($_GET['id'])){
			$action = "showOne";
	  }else{
			$action = "showAll";
	  }
	  
	  
?>

    
    <section class="container">
      <div id="blankBuffer"></div>
      <section class="container" id="mainContent">
	    <div class="row">
		  <div class="span12">
				  <div id="glossaryOffset" class="clearfix">
						<h1>Welcome to our Produce Glossary</h1>
						<p>Take a look around and find storage and preparation tips on your favorite produce items ... and some items you may have never heard of. Whether you want to learn more about the UGLI fruit (yeah, it exists, and it is tasty!) or you want to know how to make your apples last longer, you can find that information here. Not to mention that each item has great recipes that show off its natural awesomeness.</p>
						
						<div id="alphaNav" class="hidden-phone">
							  <div id="column3">
								  <p><a href="#glossaryOffset" class="arctic_scroll" data-offset="-30">Go to top of page</a></p>
							  </div>
						</div>
						
						<div id="phoneAlphaContain" class="visible-phone">
						  <h4 id="phoneGoTo">Go to...</h4>
						  <div id="phoneAlpha" class="hideObject">
							<div id="column3">
							  <p><a href="#glossaryOffset" class="arctic_scroll" data-offset="-30">Go to top of page</a></p>
							</div>
						  </div>
						</div>
						
						<div id="glossaryContain">
							  <div id="leftCol" class="clearfix"></div>
							  <div id="rightCol" class="clearfix"></div>
						</div>
				  </div> 
			</div>
		  <!--</form>-->
	    </div>
	    
	    
      </section>
      
    </section>
      
    
    
    
    
    
    

  
  <script>
   var theAction = "<?php echo $action; ?>";
   
   
   if(theAction == "showAll"){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=getAllProduceWithRecipes",
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "allProduceCallback"
	  });
   }else if(theAction == "showOne"){
	  
   }
   
   
   function allProduceCallback(theResponse){
	  //console.log(theResponse);
	  var allLetters = new Array;
	  
	  var windowWidth = $(window).width();
	  
	  $.each(theResponse, function(){
			theItem = this['produceItem'];
			var recipeText = "";
			var recipeCount = 0;
			var theHTML = "";
			var numRecipes = this['recipes'].length;
			var recipeChoice = this['recipes'].length == 1 ? "recipe" : "recipes";
			
			var firstLetter = theItem.name.substr(0,1).toUpperCase();
			var wasFound = $.inArray(firstLetter, allLetters);
			
			if (wasFound == -1) {
				  allLetters.push(firstLetter);
			}
			
			theHTML += wasFound == -1 ? "<div class='anItem clearfix' id='" + firstLetter + "selection'>" : "<div class='anItem clearfix' id='" + theItem.name.replace(" ", "_") + "'>";
			theHTML += "<img src='https://afsshareportal.com/Kickstrap/img/glossary/" + theItem.photo + "' alt='Photo for " + theItem.name + "'>";
			//theHTML += "<div id='theShadow'>";
			//theHTML += "<img src='https://afsshareportal.com/Kickstrap/img/recipes/recipeShadow.png' alt='Shadow for Picture' width='350'>";
			//theHTML += "</div>";
			theHTML += "<h2>" + theItem.name + "</h2>";
			theHTML += "<p>" + theItem.description + "</p><br>";
			theHTML += "<div class='recipeContainer'>";
			
			theHTML += "<div class='floatLeft half'>";
			theHTML += "<span><b>Recipes:</b></span>";
			theHTML += "</div>";
			
			theHTML += "<div class='floatRight half pull-right'>";
			theHTML += "<span class='showRecipes pull-right'>";
			theHTML += "show " + numRecipes + " " + recipeChoice;
			theHTML += "</span>";
			theHTML += "</div>";
			
			theHTML += "<div class='hideObject theRecipes'>";
			
			recipeText += "<ol class='recipeList'>";
			$.each(this['recipes'], function(){
				  recipeText += recipeCount == 0 ? "<li class='firstLI'>" : "<li>";
				  recipeText += "<a href='/recipes/" + this.id + "'>" + this.DishTitle + "</a></li>";
				  recipeCount++;
			});
			recipeText += "</ol>";
			
			theHTML += recipeText;
			
			theHTML += "</div>";
			
			
			
			theHTML += "</div>";
			
			if(windowWidth > 640){
			  contentHere = fillContent("#glossaryContain");
			}else{
			  contentHere = "#leftCol";
			}
			//var contentHere = fillContent("#glossaryContain");
			
			$(contentHere).append(theHTML);
			//console.log(recipeHTML);
	  });
	  
	  var myHTML = "";
	  for(var myCount = 0; myCount < 26; myCount++){
			var letter = String.fromCharCode("A".charCodeAt(0) + myCount);
			if($.inArray(letter, allLetters) != -1){
				  myHTML += "<div class='letterNav underline' id='"+ letter +"nav'><a href='#" + letter + "selection' class='arctic_scroll' data-offset='-30'>" + letter + "</a></div>";
			}else{
				  myHTML += "<div class='letterNav' id='"+ letter +"nav'>" + letter + "</a></div>";
			}
		  
	  }
	  
	  $("#alphaNav").prepend(myHTML);
	  $("#phoneAlpha").prepend(myHTML);
	  
   }
   
	  $(".showRecipes").live("click", function(){
			$(this).parent().siblings(".theRecipes").toggleClass("hideObject");
			var theText = $(this).text();
			var theBegin = theText.substr(0,3);
			var theRemainder = $(this).text().substring(theText.indexOf(" "));
			if(theBegin == "sho"){
				  $(this).text("hide" + theRemainder);
			}else{
				  $(this).text("show" + theRemainder);
			}
	  });
	  
	  $("#phoneGoTo").bind("click", function(){
		$("#phoneAlpha").toggleClass("hideObject");
		$(this).text(($(this).text() == "Hide") ? "Go to..." : "Hide");
	  });
	  
	  $(".letterNav a").live("click", function(){
		$("#phoneGoTo").text(($("#phoneGoTo").text() == "Hide") ? "Go to..." : "Hide");
		$("#phoneAlpha").toggleClass("hideObject");
		
	  });
   
   ks.ready(function() {
      startStickyNav();
	  startStickyNavPhone();
	  // JavaScript placed here will run only once Kickstrap has loaded successfully.
   });
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>