<script src="https://afsshareportal.com/js/moment.min.js"></script>

<div id="featuredRecipe">
	<h4 class="header">Featured Recipe</h4>
    <div id="recipeOffset">
	</div>
</div>
<script src="/admin/js/includeJS.js"></script>
<script>
    var theRecipeID = "";
	var theDishTitle = "";
	getFeatRecipeId();
	
	
	
	function getFeatRecipeId(){
		$.ajax({
			type: "POST",
			url: "/admin/lookUp.php",
			data: "action=getFeatRecipe",
			dataType: "json",
			success: function(theResponse){
			  //console.log("featured: " + theResponse.recipe_id);
			  theRecipeID = theResponse[0].recipe_id;
			  theDishTitle = theResponse[0].DishTitle;
			  var now = new moment().set('hour', 0);
			  var recipeDate = new moment(theResponse[0].recipe_start);
			  var dateDiff = now.diff(recipeDate, "days");
			  
			  if(dateDiff > 14 && theResponse.length == 1){ //length is an indicator if there is another featured recipe in the future.
				getCommonFeature();
			  }else{
				getRecipe();
			  }
			}
		});
	}
	
	function getCommonFeature(){
		$.ajax({
			type: "GET",
			url: base_site + "lookUpFeatures.php",
			data: "action=getFeatRecipe",
			dataType: "jsonp",
			jsonp : "callback",
			jsonpCallback: "commonFeatureCallback"
		});
	}
	
	function commonFeatureCallback(theResponse){
		theRecipeID = theResponse[0].recipe_id;
		theDishTitle = theResponse[0].DishTitle;
		getRecipe();
	}
	
    function getRecipe(recipeID, dishTitle){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=getRecipe&id=" + theRecipeID,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "theRecipecallback"
	  });
	}
	
	function theRecipecallback(theResponse){
		
		var theHTML = "";
		var theCount = 0;
	  
		if(theResponse && theDishTitle == theResponse.DishTitle){
			theHTML += "<div id='recipe_" + theResponse['ID'] + "' class='recipeContain clearfix'>";
			theHTML += "<img src='https://afsshareportal.com/Kickstrap/img/recipes/" + theResponse['DishImage'] + "' width='244' height='244' alt='" + theResponse['DishTitle'] + "' style='float:none;'>";
			theHTML += "<h3 style='margin-top:10px;'>" + theResponse['DishTitle'] + "</h3>";
			theHTML += "<h4 class='muted'>" + theResponse['category'] + "</h4>";
			theHTML += "<p class='btn'><a href='/recipes/" + theResponse['DishTitle'].replace(/\ /g, "-") + "'>View Recipe</a></p>";
			theHTML += "</div>";
			
			$("#recipeOffset").html(theHTML);
		}else{
			$.ajax({
				type: "POST",
				url: "/admin/lookUp.php",
				data: "action=getRecipe&recipeID=" + theRecipeID,
				dataType: "json",
				success: function(theResponse){
				  //console.log(theResponse);
				  //console.log(theDishTitle);
				  if(theResponse.DishTitle == theDishTitle){
					//console.log("they match");
					theHTML += "<div id='recipe_" + theResponse.recipe_id + "' class='recipeContain clearfix'>";
					theHTML += "<h3>" + theResponse.DishTitle + "</h3>";
					theHTML += "<img src='/Kickstrap/img/" + theResponse.DishImage + "' width='125' height='125' alt='" + theResponse.DishTitle + "'>";
					theHTML += "<h4 class='muted'>" + theResponse.category + "</h4>";
					theHTML += "<p class='btn'><a href='/recipes/" + theResponse.DishTitle.replace(/\ /g, "-") + "'>View Recipe</a></p>";
					theHTML += "</div>";
				  }
				  
				  $("#recipeOffset").html(theHTML);
				  //
				}
			});
		}
	  
		
	}

    
    
		
	
</script>
