<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php") ?>
<?php
  $pageTitle = "Eldon's BBQ";
  $pageDescription = "Stokes proudly presents Eldon's BBQ";
  $pageKeywords = "BBQ, Barbecue, BBQ Box";
?>
<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php") ?>
<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php")?>
    
    
    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      
      <section class="container" id="mainContent">
        <div class="span8 leftSide">
          <h1><img src="/Kickstrap/img/EldonsHeader.jpg" width="100%" alt="Eldon's BBQ Logo" style="display: block; margin: 0 auto"></h1>
		  <h3>Eldon's Story</h3>
		  <div class="floatRightImg" style="width: 47%">
			<img src="/Kickstrap/img/eldons-case.jpg" width="100%" alt="Eldon's BBQ Case"><br><br>
			<img src="/Kickstrap/img/eldons-trailer.jpg" width="100%" alt="Eldon's BBQ Trailer"><br><br>
			<img src="/Kickstrap/img/eldons.jpg" width="100%" alt="Eldon's BBQ Sitting Area">
		  </div>
		  <p>Eldon Packer Stokes along with his son, John Robert Stokes, founded "Stokes House of Fine Meats." Eldon was a third generation grocer. With his passion for the grocery business and his love of meat, he decided to open a grocery store heavily focused on meat. Eldon loved prime rib, as well as other	BBQ favorites. If you couldn't finish your plate of meat, Eldon would finish it for you. The better the meat was prepared, the more it was enjoyed. </p>
		  <p>In remembrance of our Grandpa Eldon and for his love of great meat and his passion for the grocery business, we bring you Eldon's BBQ!</p>
		  <h3>Our Products</h3>
		  
		
		  <ul><b>Offering delicious:</b>
			<li>smoked pulled pork</li>
			<li>baby back ribs</li>
			<li>brisket</li>
			<li>turkey and sausage</li> 
		  </ul>
		  
		  <ul><b>Sides</b>
			<li>spicy mac &amp; cheese</li>
			<li>coleslaw</li>
			<li>loaded mashed potatoes</li>
			<li>barbecue beans</li>
		  </ul>
		  
		  <h3>Eldon's Catering Request</h3>
		  <p>We cater events and parties! Contact us below with the details of your event and we will provide you with a quote and availability.</p>
		  <form action="/formmail.php" name="cateringForm" id="cateringForm" method="post">
			<input type="hidden" name="env_report" value="REMOTE_HOST,REMOTE_ADDR,HTTP_USER_AGENT,AUTH_TYPE,REMOTE_USER" />
			<input type="hidden" name="recipients" id="recipients" value="stokesgr@yahoo.com" />
			<input type="hidden" name="required" value="name:Your name" />
			<input type="hidden" name="subject" value="Catering Request from website" />
			<input type="hidden" name="good_url" value="<?php echo DOC_ROOT; ?>thanks.php">
			
			<fieldset> 
			  <div class="textInput">
				  <label for="name">Name</label>
				  <span id="nameError" class="hideObject text-error">You must enter your name</span>
				  <input type="text" value="" name="name" id="name" required>
			  </div>
			  
			  <div class="selectInput">
				  <label>Preferred Contact Method</label>
				  <span id="contactMethodError" class="hideObject text-error">You must choose a contact method<br></span>
				  <select class="selectInput" name="contactMethod" id="contactMethod">
					<option value="none">Select Method</option>
					<option value="phone">Phone</option>
					<option value="email">Email</option>
				  </select>
			  </div>
			  
			  <div class="textInput hideObject">
				  <label for="phone">Phone Number (Optional)</label>
				  <span id="phoneError" class="hideObject text-error">You must enter a phone number<br></span>
				  <input type="text" value="" name="phone" id="phone" class="h5-phone">
			  </div>
		  
			  <div class="textInput hideObject">
				  <label for="email">Email Address</label>
				  <span id="emailError" class="hideObject text-error">You must enter a valid email address<br></span>
				  <input type="email" value="" name="email" id="email">
			  </div>
			  
			  <div class="textInput">
				  <label for="eventDate">Date of Event</label>
				  <input type="text" value="" name="eventDate" id="eventDate">
			  </div>
			  
			  <div class="textInput">
				  <label for="people">How many people are you feeding?</label>
				  <input type="text" value="" name="people" id="people">
			  </div>
			  
			  <div class="selectInput">
				  <label>What type of catering?</label>
				  <select class="selectInput" name="cateringType" id="cateringType">
					<option value="none">Select Catering Type</option>
					<option value="onsite">Cooking onsite</option>
					<option value="store">Pickup at store</option>
					<option value="deliver">Deliver to Location</option>
				  </select>
			  </div>
			  
			  <div class="textAreaInput">
				  <input type="hidden" value="" name="i3mj9of" id="i3mj9of">
				  <input type="hidden" value="en329" name="e2mp06a" id="e2mp06a">
			  </div>
			  
			  <div class="submitButtonContainer">
				  <input type="submit" class='btn btn-primary' value="Submit">
			  </div>
			</fieldset>
		  </form>
        </div><!-- end right side div -->
        
        <div class="span4 rightSide">
		  <?php include($_SERVER['DOCUMENT_ROOT'] . "/includes/sidebar.php"); ?>
		</div>
        
      </section>
    </section>
      
    
    <?php include_once($_SERVER['DOCUMENT_ROOT'] . "/common/footer.php"); ?>
  <script>
    
	if ($.browser.msie) {
	  $("#ieWarnMsg").removeClass("hideObject");
	}
	
    function getStoreLocations(){
      $.ajax({
          type: "POST",
          url: "/admin/lookUp.php",
          data: "action=getStoreLocations",
          dataType: "json",
          success: function(theResponse){
              var theHTML = "";
              var theCount = theResponse.length;
              
              if(theCount > 1){
                $.each(theResponse, function(){
				  theHTML += "<option value='" + this.store_id_share + "'>" + this.store_name + "</option>";
                });
                
                $("#location").append(theHTML);
                $("#locationSelectContainer").removeClass("hideObject");
              }else{
                setTimeout(function(){
                  $("#location").closest("div").remove();
                  document.location.href = adVersions['version1']['link'];
				  //$("#weeklyAdHolder").attr("src", adVersions['version1']['link']).removeClass("hideObject");
                }, 750);
              }
          }
      });
    }
    
    $("#location").live("change", function(){
      var theChosenId = $(":selected", this).attr("value");
      theChosenId = parseInt(theChosenId);
      
	  var theStoreName = " for " + $(":selected", this).html();
      var theChosenURL = "";
	  
      
      
      if(theChosenId !=0){
        $.each(adVersions, function(){
          if($.inArray(theChosenId, this['stores']) !== -1){
            //$("#weeklyAdHolder").attr("src", this['link']);
			if(theChosenId == 125){
			  //$("#weeklyAdPageBtn").after("<a id='aceAdBtn' class='btn btn-large' href='https://afsshareportal.com/postingFolder/PDFs/BVHA_StokesAce.pdf'>Ace Hardware Ad</a>");
			  $("#weeklyAdPageBtn").attr("href", this['link']).removeClass("hideObject");
			  $("#noAd").remove();
			  $("#locName").html(theStoreName);
			}else{
			  $("#aceAdBtn").remove();
			  $("#noAd").remove();
			  document.location.href = this['link'];
			}
          }
        });
        
		
		
        //$("#weeklyAdHolder").removeClass("hideObject");
      }
      
    });
    
    getStoreLocations();
    
    $("#rightSidebarCollapse h4").bind("click", function(){
      $this = $(this).children("i");
      $siblings = $(this).parents(".accordion-group").siblings();
      $("h4", $siblings).children("i").removeClass("icon-minus-sign").addClass("icon-plus-sign");
      if($this.hasClass("icon-plus-sign")){
        $this.removeClass("icon-plus-sign").addClass("icon-minus-sign");
      }else{
        $this.removeClass("icon-minus-sign").addClass("icon-plus-sign");
      }
    });
	
	$("#cateringForm").submit(function(event){
      event.preventDefault();
	  
	  $("#contactMethodError, #phoneError, #emailError").addClass("hideObject");
	  var contactVal = $("#contactMethod :selected").val();
	  
	  if(contactVal == "none"){
		$("#contactMethodError").removeClass("hideObject");
		return false;
	  }else if(contactVal == "phone"){
		if($("#phone").text() == ""){
		  $("#phoneError").removeClass("hideObject");
		  return false;
		}
	  }else if(contactVal == "email"){
		if($("#email").text() == ""){
		  $("#emailError").removeClass("hideObject");
		  return false;
		}
	  }
	  
	  self.unbind('submit').submit();
	});
	
	$("#contactMethod").on("change", function(){
	  var theValue = $(":selected", this).val();
	  
	  if(theValue == "phone"){
		$("#phone").closest(".textInput").removeClass("hideObject");
		$("#email").closest(".textInput").addClass("hideObject");
	  }else if(theValue == "email"){
		$("#email").closest(".textInput").removeClass("hideObject");
		$("#phone").closest(".textInput").addClass("hideObject");
	  }else{
		$("#email").closest(".textInput").addClass("hideObject");
		$("#phone").closest(".textInput").addClass("hideObject");
	  }
	});
   
   
  </script>
</body>
</html>
