<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Users";
  $pageDescription = "";
  $pageKeywords = "";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
?>

    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
			  <div id="userContainer" class="clearfix">
				<h2 class="pull-left">Users Information</h2>
				<a href="#" id="addUser" class="btn btn-primary pull-right">Add User</a>
			  </div>
			  <div id="successUpdate" class="hideObject">
				<div class="alert alert-success">
					  <a class="close" data-dismiss="alert" href="#">x</a><span id="successText"></span>
				</div>
			  </div>
			  <div id="usersInfo">
				
			  </div>
			</div>
		  </div>
	    </div>
	    
      </section>
      
    </section>
      

  <script>
    $("#addUser").bind("click", function(e){
	  e.preventDefault();
	  
	  var theHTML = "";
	  
	  //theHTML += '<form method="POST" action="signup.php" name="loginform" id="loginform" class="cf" accept-charset="UTF-8">';
	  theHTML += '<div id="newUserContain">';
	  theHTML += '<label for="useremail">User Email</label><input class="span4" placeholder="User Email" type="text" name="useremail" id="useremail"><br>';
	  theHTML += '<label for="password">Password</label><input class="span4" placeholder="Password" type="password" name="password" id="password" ><br>';
	  theHTML += '<a class="btn" id="userSubmit">Submit</a><br><br>';
	  theHTML += "</div>";
	  
	  $("#userContainer").after(theHTML);
	});
    
	
	$("body").on("click", "#userSubmit", function(e){
	  e.preventDefault();
	  var useremail = $("#useremail").val();
	  var password = $("#password").val();
	  
	  var theData = [];
	  theData = {"action": "newUser", "useremail": useremail, "password": password};
	  
	  $.ajax({
		type: "POST",
		url: "interactions.php",
		data: theData,
		success: function(theResponse){
		  //console.log(theResponse);
		  getUserInfo();
		  
		  $("#newUserContain").remove();
		  if(theResponse == true){
			$("#successText").text("You successfully added the user");
			$("#successUpdate").removeClass("hideObject");
		  }else{
			$("#successText").text("There was an error when adding the user. Please try again.");
			$("#successUpdate div").removeClass("alert-success").addClass("alert-error");
			$("#successUpdate").removeClass("hideObject");
		  }
		}
	  });
	});
	
	
	function getUserInfo(){
	  $.ajax({
		type: "POST",
		url: "interactions.php",
		data: "action=getUsers",
		success: function(theResponse){
		  var theHTML = "<table cellpadding='5'>";
		  theHTML += "<thead><td>User Name</td><td>Email</td><td>Can Edit</td><td>&nbsp;</td><td>&nbsp;</td></thead><tbody>";
		  
		  
		  
		  $.each(theResponse, function(){
			if(this.user_email != "webmaster@afsshareportal.com"){
			  var userEdit = this.user_edit == 0 ? "No" : "Yes";
			  
			  var editDropDown = "<select class='editChange'>";
			  if(this.user_edit == 0){
				editDropDown += "<option value='0' selected='selected'> No </option>";
				editDropDown += "<option value='1'> Yes </option>";
			  }else{
				editDropDown += "<option value='0'> No </option>";
				editDropDown += "<option value='1' selected='selected'> Yes </option>";
			  }
			  editDropDown += "</select>";
			  
			  theHTML += "<tr id='user_" + this.UserID + "'>";
			  theHTML += "<td>" + this.Username + "</td>";
			  theHTML += "<td>" + this.user_email + "</td>";
			  theHTML += "<td>" + editDropDown + "</td>";
			  theHTML += "<td><span class='removeUser'><i class='icon-remove' title='Delete User'></i></span></td>";
			  theHTML += "<td><span class='changePass'><i class='icon-edit' title='Change Password'></i></span></td>";
			  theHTML += "</tr>";
			}
		  });
		  
		  theHTML += "</tbody></table>";
		  
		  
		  $("#usersInfo").html(theHTML);
		  $("#usersInfo tbody tr:even").addClass("oddRowColor");
		}
	  });
	  
	}
	
	getUserInfo();
	
	
   
    $("body").on("change", ".editChange", function(){
	  var $this = $(this);
	  var theID = $this.parents("tr").attr("id").replace("user_", "");
	  var theValue = $this.val();
	  var theName = $this.parents("tr").children("td:nth-child(1)").text();
	  console.log(theID, theValue);
	  $.ajax({
		type: "POST",
		url: "interactions.php",
		data: "action=changeCanEdit&userID=" + theID + "&theValue=" + theValue,
		success: function(theResponse){
		  if(theResponse == true){
			$("#successText").text("You successfully changed the editing capabilities for " + theName);
			$("#successUpdate").removeClass("hideObject");
		  }else{
			$("#successText").text("There was an error when updating. Please try again.");
			$("#successUpdate div").removeClass("alert-success").addClass("alert-error");
			$("#successUpdate").removeClass("hideObject");
		  }
		}
	  });
	  
	});
	
	$("body").on("click", ".removeUser", function(){
	  $(".deleteAlert").remove();
	  var $this = $(this);
	  var $theParent = $this.parents("tr");
	  var theID = $theParent.attr("id").replace("user_", "");
	  
	  $theParent.after("<tr class='deleteAlert' id='user_" + theID + "'><td colspan='4'>Do you really want to delete this user? <span class='removeUserConfirm btn btn-small'>Yes</span> <span class='removeUserDeny btn btn-small'>No</span></td></tr>");
	});
	
	$("body").on("click", ".removeUserConfirm", function(){
	  var $this = $(this);
	  var $theParent = $this.parents("tr");
	  var theID = $theParent.attr("id").replace("user_", "");
	  var theName = $this.parents("tr").children("td:nth-child(1)").text();
	  var $deleteThis = $("#user_" + theID);
	  
	  $.ajax({
		type: "POST",
		url: "interactions.php",
		data: "action=deleteUser&userID=" + theID,
		success: function(theResponse){
		  if(theResponse == true){
			$("#successText").text("You successfully deleted the user");
			$("#successUpdate").removeClass("hideObject");
			$deleteThis.remove();
			$theParent.remove();
		  }else{
			$("#successText").text("There was an error when deleting. Please try again.");
			$("#successUpdate div").removeClass("alert-success").addClass("alert-error");
			$("#successUpdate").removeClass("hideObject");
		  }
		}
	  });
	});
	
	$("body").on("click", ".removeUserDeny", function(){
	  $(this).parents(".deleteAlert").remove();
	});
	
	$("body").on("click", ".changePass", function(){
	  $(".passAlert").remove();
	  var $this = $(this);
	  var $theParent = $this.parents("tr");
	  var theID = $theParent.attr("id").replace("user_", "");
	  
	  $theParent.after("<tr class='passAlert' id='user_" + theID + "'><td colspan='4'>New Password: <input type='text' id='newPass'> <span class='changePassConfirm btn btn-small'>Yes</span> <span class='changePassDeny btn btn-small'>No</span></td></tr>");
	});
	
	$("body").on("click", ".changePassConfirm", function(){
	  var $this = $(this);
	  var $theParent = $this.parents("tr");
	  var theID = $theParent.attr("id").replace("user_", "");
	  var theName = $theParent.prev().children("td:nth-child(1)").text();
	  var newPass = $("#newPass").val();
	  
	  $.ajax({
		type: "POST",
		url: "interactions.php",
		data: "action=changePass&newPass=" + newPass + "&userID=" + theID,
		success: function(theResponse){
		  if(theResponse == true){
			$("#successText").text("You successfully updated " + theName + "'s password");
			$("#successUpdate").removeClass("hideObject");
			$theParent.remove();
		  }else{
			$("#successText").text("There was an error when updating the password. Please try again.");
			$("#successUpdate div").removeClass("alert-success").addClass("alert-error");
			$("#successUpdate").removeClass("hideObject");
		  }
		}
	  });
	});
	
	$("body").on("click", ".changePassDeny", function(){
	  $(this).parents(".passAlert").remove();
	});
   
   $(document).ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
      $("#usersInfo tbody tr:even").addClass("oddRowColor");
   });
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
