function jsonCallOldFeatures(theResponse){
	var theHTML = "";
	var running = new Array();
	var prevMonth = null;
	var currentMonth = null;
	
	theHTML += "<div id='innerAccordion_" + theResponse.dates.initial + "' class='accordion'>";
	$.each(theResponse.features, function(){
	  currentMonth = (this.feature_end.substr(5,2));
	  if(prevMonth != currentMonth){
		if(prevMonth != null){
		  theHTML += "</div>"; //end accordion-inner
		  theHTML += "</div>"; //end accordion-body
		  theHTML += "</div>"; //end the accordion group for the month
		}
		theHTML += "<div class='accordion-group'>";
		theHTML += "<div class='accordion-heading'>";
		theHTML += "<h4 class='accordion-toggle'  data-toggle='collapse' data-parent='#innerAccordion_" + theResponse.dates.initial + "' href='#month_" + theResponse.dates.initial + "_" + currentMonth + "'>" + months[currentMonth] + "</h4>";
		theHTML += "</div>"; //end accordion-heading
		theHTML += "<div class='accordion-body collapse' id='month_" + theResponse.dates.initial + "_" + currentMonth + "'>";
		theHTML += "<div class='accordion-inner'>"
	  }
	  theHTML += formatFeature(this, running, false);
	  allFeatures.push(this);
	  
	  prevMonth = this.feature_end.substr(5,2);
	});
	theHTML += "</div>"; //end the final accordion-inner
	theHTML += "</div>"; //end the final accordion-body
	theHTML += "</div>"; //end the final accordion group for the months
	theHTML += "</div>"; //end the accordion
	
	$("#year_" + theResponse.dates.initial + " .accordion-body .accordion-inner").append(theHTML);
	$("#year_" + theResponse.dates.initial).addClass("filled");
	$("#oldSGfeatures").removeClass("hideObject");
}

function formatFeature(theFeature, runningFeatures, canAdd){
	var theHTML = "";
	var featID = theFeature.feature_id;
	var featName = theFeature.feature_name.replace(/\\/g, '');
	var featHeadline = theFeature.feature_headline.replace(/\\/g, '');
	var featText = theFeature.feature_text.replace(/\\/g, '');
	var common = theFeature.feature_common;
	var commonText = common == 1 ? "(Common)" : "";
	if(theFeature.feature_photoSquare.substr(0,4) != "http"){
		var featPhoto = base_site + theFeature.feature_photoSquare;
	}else{
		var featPhoto = theFeature.feature_photoSquare;
	}
	var featStart = theFeature.feature_start;
	var featEnd = theFeature.feature_end;
	
	//var theClass = theCount == 0 ? "active" : "";
	
	//This statement limits the common features. It shows all non-common features unconditionally. If it is a common feature, it will only be shown if the count of features already processed is less than the set number (3)
	//if(common == 0 || (common == 1 && theCount < 3)){
	
	theHTML += '<div class="span8 aFeature" id="feature_' + featID + '">';
	theHTML += '<h3>' + featName + ' <small>' + commonText + '</small></h3>'
	theHTML += '<div class="clearfix negMargTop">'
	theHTML += '<img src="' + featPhoto + '" width="125" height="125" class="featureSquare" alt="' + featName + '">';
	theHTML += '<h4>' + featHeadline + '</h4>';
	theHTML += '<p class="featureDate"><small>' + featStart + ' - ' + featEnd + '</small></p>';
	theHTML += '<p>' + featText + '</p>';
	theHTML += '</div>';
	theHTML += '<p class="duplicateFeat btn btn-small"><i class="icon-copy icon-large"></i> Duplicate Feature</p>';
	theHTML += '<div class="runFeature">';
	if(canAdd == true){
	  if($.inArray(featName, runningFeatures) >= 0){
		if(common == 1){
		  theHTML += '<p class="alert alert-success"><span class="alertText">You are running this promotion. <br>It is a generic feature that is used for filler when there are not enough features.</span>';
		  theHTML += '<br><a class="btn btn-small btn-danger usingFeatureCommon" href="#" style="color:#fff;">Remove Feature</a>';
		  theHTML += '</p>';
		}else{
		  theHTML += '<p class="alert alert-success"><span class="alertText">You are running this promotion.</span>';
		  theHTML += '<br><a class="btn btn-small btn-danger usingFeature" href="#" style="color:#fff;">Remove Feature</a>';
		  theHTML += '</p>';
		}
	  }else{
		if(common == 1){
			theHTML += '<p class="alert alert-error"><span class="alertText">You are not running this promotion.</span>';
		theHTML += '<br><a class="btn btn-small btn-success usingFeatureCommon" href="#" style="color:#fff;">Add Feature</a>';
		theHTML += '</p>';
		}else{
			theHTML += '<p class="alert alert-error"><span class="alertText">You are not running this promotion.</span>';
		theHTML += '<br><a class="btn btn-small btn-success usingFeature" href="#" style="color:#fff;">Add Feature</a>';
		theHTML += '</p>';
		}
	  }
	}
	theHTML += '</div>';
	theHTML += '</div>';
	
	return theHTML;
}

function buildCalendar(month, year, refDate) {
	var theDate = new moment(refDate);
	var monthNum = theDate.month() + 1;
	
	var today = new moment();
    var today_date = today.date();

	if(today.month() == theDate.month()){
		var hasToday = true;
	}else{
		var hasToday = false;
	}
	// Create array containing abbreviations of days of week.
	var daysOfWeek = new Array('S','M','T','W','T','F','S');
	
	// What is the index value (0-6) of the first day of the
	// month in question.
	var dayOfWeek = theDate.day();
	
	// How many days does this month contain?
	var numberDays = theDate.daysInMonth();
	
	// Create the table tag opener and day headers
	
	var calendar = "<table class='calendar' id='" + refDate + "'>";
	calendar += "<caption><i class='icon-caret-left floatLeft' id='prevMonth'></i> " + month + " " + year + " <i class='icon-caret-right floatRight' id='nextMonth'></i></caption>";
	calendar += "<tr>";
	
	// Create the calendar headers
	
	$.each(daysOfWeek, function(key, day) {
		 calendar += "<th class='header'>" + day + "</th>";
	});
	
	// Create the rest of the calendar
	
	// Initiate the day counter, starting with the 1st.
	
	currentDay = 1;
	
	calendar += "</tr><tr>";
	
	// The variable var dayOfWeek is used to
	// ensure that the calendar
	// display consists of exactly 7 columns.
	if (dayOfWeek > 0) { 
		for(var counter = dayOfWeek; counter > 0; counter--){
			calendar += "<td class='blankDay'>&nbsp;</td>"; 
		}
	}
	
	//month = str_pad(month, 2, "0", STR_PAD_LEFT);
	monthNum = "" + monthNum;
	var newMonthNum = monthNum.length == 2 ? monthNum : "0" + monthNum;
	
	while (currentDay <= numberDays) {
	
		// Seventh column (Saturday) reached. Start a new row.
	
		if (dayOfWeek == 7) {
	
			var dayOfWeek = 0;
			calendar += "</tr><tr>";
	
		}
		
		currentDay = "" + currentDay;
		
		var currentDayRel = currentDay.length == 2 ? currentDay : "0" + currentDay;
		var date = year + "-" + newMonthNum + "-" + currentDayRel;
		 
		if(currentDayRel == today_date && hasToday == true){
			calendar += "<td class='day' id='today_date' rel='" + date + "'><b>" + currentDay + "</b></td>";
		}else {
			calendar += "<td class='day' rel='" + date + "'>" + currentDay + "</td>";
		}
	
		// Increment counters
	
		currentDay++;
		dayOfWeek++;
	
	}
	
	
	
	
	// Complete the row of the last week in month, if necessary
	
	if (dayOfWeek != 7) { 
	
		var remainingDays = 7 - dayOfWeek;
		for(var aCounter = remainingDays; aCounter > 0; aCounter--){
			calendar += "<td class='blankDay'>&nbsp;</td>";
		}
	
	}
	
	calendar += "</tr>";
	
	calendar += "</table>";
	
	return calendar;

}

function getLunchOptions(){
	/*
	$.ajax({
	  type: "GET",
	  url: base_site + "lookUpFeatures.php",
	  data: "action=getDeli",
	  dataType: "jsonp",
	  jsonp : "callback",
	  jsonpCallback: "deliForm"
	});
	*/
	$.ajax({
		type: "POST",
		url: "/admin/lookUp.php",
		data: "action=getDeliItems",
		dataType: "json",
		success: function(theResponse){
			//console.log(theResponse);
			deliDropdown = "<div id='deliDropdown'>";
			var theCount = 0;
			
			deliDropdown += "<h4>Change a Special</h4>";
			deliDropdown += "<label for='changeType'>Which special do you want to change? </label>";
			deliDropdown += "<select id='changeType' name='changeType'>";
			$.each(config, function(key){
				deliDropdown += "<option value='" + key + "'>" + this['dropdown-name'] + " Special</option>";
			});
			deliDropdown += "</select>";
			deliDropdown += "<label for='changeLunch'>New Item:</label>";
			deliDropdown += "<select id='changeLunch' name='changeLunch'>";
			$.each(theResponse, function(){
			  deliItems[this.deli_id] = {"name": this.deli_name, "photo": this.deli_photo};
			  deliDropdown += "<option value='deli_" + this.deli_id + "'>" + this.deli_name + "</option>"
			});
			deliDropdown += "</select>";
			deliDropdown += "<br><br><label for='priceDollars'>Cost: </label>$ <input type='text' name='priceDollars' maxlength='3' style='width:50px'> . <input type='text' name='priceCents' maxlength='2' style='width:50px'>";
			deliDropdown += "<br><br><label for='itemDesc'>Description</label><textarea name='itemDesc' id='itemDesc' class='span3' rows='4'></textarea>";
			deliDropdown += "<br><a href='#' class='btn btn-primary' id='changeLunchBtn'>Submit</a>";
			deliDropdown += "</div>";
			
			$("#viewLunch").html("Select a date to see the special");
		  
		}
	});
}

function formatDateString(theDate){
	var year = theDate.getFullYear();
	var month = theDate.getMonth() + 1;
	var newMonthString = "" + month;
	newMonthString = newMonthString.length == 1 ? "0" + newMonthString : newMonthString;
	
	
	var day = theDate.getDate();
	var newDayString = "" + day;
	newDayString = newDayString.length == 1 ? "0" + newDayString : newDayString;
	
	var constructed = year + "-" + newMonthString + "-" + newDayString;
	return(constructed);
}

function formatDateNice(theDateString, yearWanted){
	var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
	
	var dateComponents = theDateString.split("-");
	var year = dateComponents[0];
	var month = dateComponents[1]-1;
	var monthName = months[month];
	var day = dateComponents[2];
	
	if(day.substr(0,1) == "0"){
		day = day.substr(1,1);
	}
	
	var constructed = monthName + " " + day;
	
	if(yearWanted == true){
		constructed += ", " + year;
	}
	
	return(constructed);
}

function fillContent(parentSelect){
	var allChildren = $(parentSelect).children();
	//console.log(allChildren);
	var theHeight = $(parentSelect).children().first().height();
	var theSelector = $(parentSelect).children().first().attr("id");
	var theHeights = new Array();
	
	//console.log("INSIDE FILL CONTENT\nleft: " + $("#leftCol").height() + "\nright: " + $("#rightCol").height());
	
	allChildren.each(function(){
		//console.log("IN ALL CHILDREN EACH FUNCTION\n" + $(this).attr("id") + ": " + $(this).height() + "\nexist Height:" + theHeight + "\nexist Selector:" + theSelector);
		if($(this).height() == 0 && theSelector == ""){
			theHeight = $(this).height();
			theSelector = $(this).attr("id");
		}else if($(this).height() < theHeight){
			theHeight = $(this).height();
			theSelector = $(this).attr("id");
		}
		//console.log("currentSelector: " + theSelector);
	});
	
	//console.log("theSelector is: " + theSelector);
	if(theSelector == ""){
		theSelector = $(parentSelect).children().first().attr("id");
	}
	
	//console.log(theHeights['height']);
	return "#" + theSelector;
	//console.log(theMax);
}

function startStickyNav(){
	
	var $window = $(window);
	var $stickyEl = $('#column3 a');
	var $stickyNav = $('#alphaNav');
	
	
	var elTop = $stickyEl.offset().top;
	var navTop = $stickyNav.offset().top;
	
	$window.scroll(function() {
		var windowTop = $window.scrollTop();
		//windowTopAdded = windowTop + 200;
		
		$stickyNav.toggleClass('stickyNav', windowTop > navTop);
		//$("#thePageHeader").toggleClass('extraBottom', windowTop > navTop);
		//$stickyEl.toggleClass('whiteText', windowTop > navTop);
	});

}

function startStickyNavPhone(){
	
	var $window = $(window);
	var $stickyNav = $('#phoneAlphaContain');
	
	
	var navTop = $stickyNav.offset().top;
	
	$window.scroll(function() {
		var windowTop = $window.scrollTop();
		//windowTopAdded = windowTop + 200;
		
		$stickyNav.toggleClass('stickyNav', windowTop > navTop);
		//$("#thePageHeader").toggleClass('extraBottom', windowTop > navTop);
		//$stickyEl.toggleClass('whiteText', windowTop > navTop);
	});

}

/*Arctic Scroll for smooth transitions*/ (function ($) {
	$.fn
		.arctic_scroll = function (options) {

		var defaults = {
			elem: $(this),
			speed: 500
		};
		var options = $.extend(defaults, options);

		options.elem
			.click(function (event) {
			event.preventDefault();
			var offset = ($(this).attr('data-offset')) ? $(this).attr('data-offset') : false,
				position = ($(this).attr('data-position')) ? $(this).attr('data-position') : false;
			if (offset) {
				var toMove = parseInt(offset);
				$('html,body').stop(true, false)
					.animate({
					scrollTop: ($(this.hash).offset()
						.top + toMove)
				}, options.speed);
			} else if (position) {
				var toMove = parseInt(position);
				$('html,body').stop(true, false)
					.animate({
					scrollTop: toMove
				}, options.speed);
			} else {
				$('html,body').stop(true, false)
					.animate({
					scrollTop: ($(this.hash).offset()
						.top)
				}, options.speed);
			}
		});

	};
})(jQuery);

$(function () {
	$(".arctic_scroll").arctic_scroll({
		speed: 800
	});
});

function myAutocompleteFeatures(){
	if($("#autocomplete").val() != "undefined"){
		//console.log($("#oldFeatures .aFeature"));
		var theFeatures = $.map($("#oldFeatures .aFeature"), function(n){
			var value = $(".span7", n).attr("id");
			var title = $(".span7 h2", n).text();
			return {"label": title, "value": value};
		});
		//console.log(theFeatures);
		searchVal = $("#autocomplete").val();
			
		if(searchVal != ""){
			$("#autocomplete").val("");	
		}
		
		$("#autocomplete").autocomplete({
			minLength: 1,
			position: { my : "right top", at: "right bottom" },
			source: theFeatures,
			focus: function( event, ui ) {
				$( "#autocomplete" ).val( ui.item.label );
				return false;
			},
			select: function(event, ui) {
				//$("#storeHide").addClass('hideObject');
				//$("#display").removeClass('hideObject');
				event.preventDefault();
				$("#autocomplete").val(ui.item.label);
				$("#" + ui.item.value).parents(".accordion-body").siblings(".accordion-heading").children(".accordion-toggle").each(function(){
					if(!$(this).parent().siblings(".accordion-body").is(".in")){
						$(this).click();
					}
				});
				$(".aFeature").removeClass("leftBorder");
				$("#" + ui.item.value).parents(".aFeature").addClass("leftBorder");
				setTimeout(function(){
					$(".aFeature.leftBorder").removeClass(".leftBorder");
				}, 15000);
			}
		});
	}	
}

function myAutocomplete(){
	if($("#autocomplete").val() != "undefined"){
		searchVal = $("#autocomplete").val();
			
		if(searchVal != ""){
			$("#autocomplete").val("");	
		}
		
		$("#autocomplete").autocomplete({
			minLength: 2,
			source: function( request, response){
				$.ajax({
					type: "GET",
					url: "/Recipes/search.php",
					data: {
						'term':request.term	
					},
					contentType: "application/json; charset=utf-8",
					dataType:"json",
					success: function(data)
					{
						response(data);
						//console.log(data);
						$("#display").html(data).show();	
					}
				});
			},
			select: function(event, ui) {
				window.location = "/Recipes/" + ui.item.desc + "/" + ui.item.noSpace;
			},
			open: function() { $('.ui-menu').width(265) }
		});
	}	
}

function myAutocompleteRecipe(theRecipeNames){
	if($("#autocomplete").val() != "undefined"){
		searchVal = $("#autocomplete").val();
			
		if(searchVal != ""){
			$("#autocomplete").val("");	
		}
		
		$("#autocomplete").autocomplete({
			minLength: 1,
			position: { my : "right top", at: "right bottom" },
			source: theRecipeNames,
			focus: function( event, ui ) {
				$( "#autocomplete" ).val( ui.item.label );
				return false;
			},
			select: function(event, ui) {
				//$("#storeHide").addClass('hideObject');
				//$("#display").removeClass('hideObject');
				//console.log(ui.item);
				window.location = "/recipes/" + ui.item.value;
			}
		});
	}	
}

function myAutocompleteShopping(){
	if($("#autocomplete").val() != "undefined"){
		searchVal = $("#autocomplete").val();
			
		if(searchVal != ""){
			$("#autocomplete").val("");	
		}
		
		var storeNum = $("#locationSpan").attr("class");
		
		$("#autocomplete").autocomplete({
			minLength: 0,
			position: { my : "right top", at: "right bottom" },
			source: function( request, response){
				$.ajax({
					type: "GET",
					url: "/admin/lookUp.php",
					data: {
						'action': "dirSearch",
						'term':request.term,
						'storeNum':1 
					},
					contentType: "application/json; charset=utf-8",
					dataType:"json",
					success: function(data)
					{
						//console.log(data);
						$("#autocomplete").autocomplete("close");
						//$("#storeHide").addClass('hideObject');
						//$("#display").removeClass('hideObject');
						var myHTML = "";
						$("#draggable #fromHere li").addClass("hideObject");
						$.each(data, function(){
							console.log
							$("#draggable #fromHere li div#item" + this.item_id).parent().removeClass("hideObject");
						});
						
						//$("#theResults").html(myHTML);
						//$("#theResults tr:nth-child(2n-1)").addClass("grayBG");
						
						response(data);
						
						if(request.term == ""){
							$("#draggable #fromHere li").removeClass("hideObject");
						}
						//$("#display").html(data).show();	
					}
				});
			},
			select: function(event, ui) {
				$("#storeHide").addClass('hideObject');
				$("#display").removeClass('hideObject');
				//window.location = "/Recipes/" + ui.item.desc + "/" + ui.item.noSpace;
			},
			open: function() { $('.ui-menu').width(265) }
		});
	}	
}

function myAutocompleteDirectory(){
	if($("#autocomplete").val() != "undefined"){
		searchVal = $("#autocomplete").val();
			
		if(searchVal != ""){
			$("#autocomplete").val("");	
		}
		
		var storeNum = $("#locationSpan").attr("class");
		
		$("#autocomplete").autocomplete({
			minLength: 0,
			position: { my : "right top", at: "right bottom" },
			source: function( request, response){
				$.ajax({
					type: "GET",
					url: "/admin/lookUp.php",
					data: {
						'action': "dirSearch",
						'term':request.term,
						'storeNum':1 
					},
					contentType: "application/json; charset=utf-8",
					dataType:"json",
					success: function(data)
					{
						//console.log(data);
						$("#autocomplete").autocomplete("close");
						$("#storeHide").addClass('hideObject');
						$("#display").removeClass('hideObject');
						var myHTML = "";
						$.each(data, function(){
							myHTML += "<tr><td><span class='itemName'>" + this.item_name + ":</span></td><td><span id='" + this.item_id + "' class='itemLocation'>Aisle " + this.aisle + "</span></td></tr>";
						});
						
						$("#theResults").html(myHTML);
						$("#theResults tr:nth-child(2n-1)").addClass("grayBG");
						
						response(data);
						
						//$("#display").html(data).show();	
					}
				});
			},
			select: function(event, ui) {
				$("#storeHide").addClass('hideObject');
				$("#display").removeClass('hideObject');
				//window.location = "/Recipes/" + ui.item.desc + "/" + ui.item.noSpace;
			},
			open: function() { $('.ui-menu').width(265) }
		});
	}	
}

function getUrlVars()
{
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}

function getStoreInfo(){
	$.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=storeInfo&website_url=" + web_URL,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallbackInfo"
	});
}

function getStoreInfoAllStores(){
	$.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=storeInfo&website_url=" + web_URL,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallbackInfoAll"
	});
}

function getStoreInfoWeeklyAd(){
	$.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=storeInfo&website_url=" + web_URL,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallbackInfoWeeklyAd"
	});
}

function getPharmacyInfoAllStores(){
	$.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=storeInfo&website_url=" + web_URL,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallbackInfoPharmacy"
	});
}
	

function jsonpcallbackInfoAll(theStoreInfo){
	//console.log(theStoreID);
	var theHTML = "";
	var storeInfo = "";
    var theCnt = 0;
	//console.log(theStoreInfo);
	$.each(theStoreInfo, function(){
		//console.log(this);
		if (theCnt == 4) {
            storeInfo += "<div style='clear:both;'></div>";
        }
        var theState = this.store_state;
		storeInfo += "<div class='span3'>";
		storeInfo += "<h3>" + this.store_name.replace("Stokes ", "") + "</h3>";
		//storeInfo += "<img src='/Kickstrap/img/storeFront" + this.store_name.replace("Stokes ", "").toLowerCase() + ".jpg' width='100%'>";
		storeInfo += "<h5>Store Address</h5>";
		storeInfo += "<p>" + this.store_address + "<br><span id='storeCity'>" + this.store_city + "</span>, <span id='storeState'>" + theState + "</span> " + this.store_zip + "</p>";
		
		storeInfo += "<h5>Store Hours</h5>";
		if(this.store_hMonOpen == this.store_hSatOpen && this.store_hMonClose == this.store_hSatClose){
			storeInfo += "<p>Mon-Sat: ";
			storeInfo += "<span>" + this.store_hMonOpen + " - " + this.store_hMonClose + "</span></p>";
		}else{
			storeInfo += "<p>Mon-Fri: ";
			storeInfo += "<span>" + this.store_hMonOpen + " - " + this.store_hMonClose + "</span></p>";
			storeInfo += "<p>Saturday: ";
			storeInfo += "<span>" + this.store_hSatOpen + " - " + this.store_hSatClose + "</span></p>";
		}
		
		if(this.store_hSunOpen == "Closed"){
			storeInfo += "<p>Sunday: ";
			storeInfo += "<span>Closed</span></p>";
		}else{
			storeInfo += "<p>Sunday: ";
			storeInfo += "<span>" + this.store_hSunOpen + " - " + this.store_hSunClose + "</span></p>";
		}
		
		storeInfo += "<h5>Phone Number</h5>";
		storeInfo += "<p><a href='tel:" + this.store_phone + "'>" + this.store_phone.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</a></p>";
		
		if(this.store_hMonOpenPharm != ""){
			storeInfo += "<h5>Pharmacy Phone Number</h5>";
			storeInfo += "<p><a href='tel:" + this.store_pharmPhone + "'>" + this.store_pharmPhone.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</a></p>";
			
			storeInfo += "<h5>Pharmacy Hours</h5>";
			if(this.store_hMonOpenPharm == this.store_hSatOpenPharm && this.store_hMonClosePharm == this.store_hSatClosePharm){
				storeInfo += "<p>Mon-Sat: ";
				storeInfo += "<span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
			}else{
				storeInfo += "<p>Mon-Fri: ";
				storeInfo += "<span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
				storeInfo += "<p>Saturday: ";
				storeInfo += "<span>" + this.store_hSatOpenPharm + " - " + this.store_hSatClosePharm + "</span></p>";
			}
			
			if(this.store_hSunOpenPharm == "Closed"){
				storeInfo += "<p>Sunday: ";
				storeInfo += "<span>Closed</span></p>";
			}else{
				storeInfo += "<p>Sunday: ";
				storeInfo += "<span>" + this.store_hSunOpenPharm + " - " + this.store_hSunClosePharm + "</span></p>";
			}
		}
		
		storeInfo += "<br><p class='storeInfoBtnContain'><a href='/" + this.store_name.replace("Stokes ", "").replace(" ", "_").toLowerCase() + "' class='btn'>See all information</a></p>";
		storeInfo += "</div>";
        theCnt++;
	});
	
	$("#allStoreContain").html(storeInfo);
	
}


function jsonpcallbackInfoWeeklyAd(theStoreInfo){
	//console.log(theStoreID);
	var afsStoreNum = 0;
	var adViewerLink = "";
	//console.log(theStoreInfo);
	$.each(theStoreInfo, function(){
		afsStoreNum = this.store_id;
		adViewerLink = this.store_adViewer;
		
		adViewerInfo.push([afsStoreNum, adViewerLink]);
	});
	
}

function jsonpcallbackInfoPharmacy(theStoreInfo){
	//console.log(theStoreID);
	var theHTML = "";
	var storeInfo = "";
	//console.log(theStoreInfo);
	$.each(theStoreInfo, function(){
		//console.log(this);
		if(this.store_hMonOpenPharm != ""){
				
			storeInfo += "<div class='pharmacyLocations' id='" + this.store_name.replace("Lee's ", "").replace(".", "").replace(" ", "").toLowerCase() + "'>";
			storeInfo += "<h3>" + this.store_name.replace("Lee's ", "") + "</h3>";
			//storeInfo += "<h5>Store Address</h5>";
			storeInfo += "<p>" + this.store_address + "<br><span id='storeCity'>" + this.store_city + "</span>, <span id='storeState'>" + theStateAbbr + "</span> " + this.store_zip + "</p>";
			
			
			if(this.store_hMonOpenPharm != ""){
				storeInfo += "<b>Pharmacy Hours</b>";
				if(this.store_hMonOpenPharm == this.store_hSatOpenPharm && this.store_hMonClosePharm == this.store_hSatClosePharm){
					storeInfo += "<p>Mon-Sat: ";
					storeInfo += "<br><span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
				}else{
					storeInfo += "<p>Mon-Fri: ";
					storeInfo += "<br><span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
					storeInfo += "<p>Saturday: ";
					storeInfo += "<br><span>" + this.store_hSatOpenPharm + " - " + this.store_hSatClosePharm + "</span></p>";
				}
				
				if(this.store_hSunOpenPharm == "Closed"){
					storeInfo += "<p>Sunday: ";
					storeInfo += "<br><span>Closed</span></p>";
				}else{
					storeInfo += "<p>Sunday: ";
					storeInfo += "<br><span>" + this.store_hSunOpenPharm + " - " + this.store_hSunClosePharm + "</span></p>";
				}
			}
			
			//storeInfo += "<h5>Phone Number</h5>";
			storeInfo += "<p><a href='tel:" + this.store_pharmPhone + "'>" + this.store_pharmPhone.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</a></p>";
			
			//storeInfo += "<p class='storeInfoBtnContain'><a href='/" + this.store_name.replace("Lee's ", "").replace(".", "").replace(" ", "_").toLowerCase() + "' class='btn' target='_blank'>Online Refill</a></p>";
			storeInfo += "</div>";
		}
	});
	
	$("#onlineRefillContainer").html(storeInfo);
	
	
}

function jsonpcallbackInfo(theStoreInfo){
	var theHTML = "";
	var storeInfo = "";
	//console.log(theStoreInfo);
	
	$.each(theStoreInfo, function(){
		//console.log(this);
		var theState = this.store_state;
		if(this.store_id == theStoreID){
			$("#theStoreName").text(this.store_name.replace("Stokes ", ""));
			
			storeInfo += "<h5>Store Hours</h5>";
			if(this.store_hMonOpen == this.store_hSatOpen && this.store_hMonClose == this.store_hSatClose){
				storeInfo += "<p>Mon-Sat: ";
				storeInfo += "<span>" + this.store_hMonOpen + " - " + this.store_hMonClose + "</span></p>";
			}else{
				storeInfo += "<p>Mon-Fri: ";
				storeInfo += "<span>" + this.store_hMonOpen + " - " + this.store_hMonClose + "</span></p>";
				storeInfo += "<p>Saturday: ";
				storeInfo += "<span>" + this.store_hSatOpen + " - " + this.store_hSatClose + "</span></p>";
			}
			
			if(this.store_hSunOpen == "Closed"){
				storeInfo += "<p>Sunday: ";
				storeInfo += "<span>Closed</span></p>";
			}else{
				storeInfo += "<p>Sunday: ";
				storeInfo += "<span>" + this.store_hSunOpen + " - " + this.store_hSunClose + "</span></p>";
			}
			
			storeInfo += "<h5>Phone Number</h5>";
			storeInfo += "<p><a href='tel:" + this.store_phone + "'>" + this.store_phone.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</a></p>";
			
			if(this.store_fax != ""){
				storeInfo += "<h5>Fax Number</h5>";
				storeInfo += "<p>" + this.store_fax.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</p>";
			}
			
			if(this.store_hMonOpenPharm != ""){
				storeInfo += "<h5>Pharmacy Phone Number</h5>";
				storeInfo += "<p><a href='tel:" + this.store_pharmPhone + "'>" + this.store_pharmPhone.replace(/(\d{3})(\d{3})(\d{4})/, '$1-$2-$3') + "</a></p>";
				
				storeInfo += "<h5>Pharmacy Hours</h5>";
				if(this.store_hMonOpenPharm == this.store_hSatOpenPharm && this.store_hMonClosePharm == this.store_hSatClosePharm){
					storeInfo += "<p>Mon-Sat: ";
					storeInfo += "<span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
				}else{
					storeInfo += "<p>Mon-Fri: ";
					storeInfo += "<span>" + this.store_hMonOpenPharm + " - " + this.store_hMonClosePharm + "</span></p>";
					storeInfo += "<p>Saturday: ";
					storeInfo += "<span>" + this.store_hSatOpenPharm + " - " + this.store_hSatClosePharm + "</span></p>";
				}
				
				if(this.store_hSunOpenPharm == "Closed"){
					storeInfo += "<p>Sunday: ";
					storeInfo += "<span>Closed</span></p>";
				}else{
					storeInfo += "<p>Sunday: ";
					storeInfo += "<span>" + this.store_hSunOpen + " - " + this.store_hSunClose + "</span></p>";
				}
			}
			
			
			storeInfo += "<h5>Store Address</h5>";
			storeInfo += "<p>" + this.store_address + "<br>" + this.store_city + ", " + this.store_state + " " + this.store_zip + "</p>";
			
			storeInfo += "<div id='mapContain'></div>";
			
			
			$.each(this.store_services, function(key, parentService){
				//console.log(parentService);
				var theCount = 0;
				$.each(parentService, function(key, aService){
					//console.log("children: " + theCount);
					if(theCount == 0 || theCount > 1){
						theHTML += "<li>" + aService + "</li>";
					}else if(theCount == 1){
						theHTML += "<ul>";
						theHTML += "<li>" + aService + "</li>";
					}
					theCount++;
					
				});
				
				if(theCount > 0){
					theHTML += "</ul>";
				}
			});
		}
	});
	
	$("#storeInfoContain").html(storeInfo);
	$("#theServices").html(theHTML);
}

function validateForm(formID){
	myInputs = $("form#" + formID + " :input");
	//alert(myInputs.length);
	var i = 0;
	$(myInputs).each(function() {
		var reqAttr = $(this).attr('required');
		if(typeof reqAttr !== 'undefined' && reqAttr !== false)
		{
			var myValue = this.value;
			var myStrippedVal = myValue.replace(" ", "");
			for(j=0; j<50; j++)
				var myStrippedVal = myStrippedVal.replace(" ", "");
			
			var myID = $(this).attr("id");
			
			if(myStrippedVal == "" || myStrippedVal == null)
			{	
				//alert("#" + myID + "Error");
				$("#" + myID + "Error").removeClass("hideObject");
				i++;
			}
			else
			{
				$("#" + myID + "Error").addClass("hideObject");
			}
		}
	});
	
	var theLocation = $("#location").find(":selected").text();
	if(theLocation == "Select Location" || theLocation == "No Location" || theLocation == "Don't see my location")
	{
		$("#locationError").removeClass("hideObject");
		i++;
	}
	else
	{
		$("#locationError").addClass("hideObject");
	}
	
	if(i == 0)
		return true;
	else
		return false;
}


function getBlacklisted(){
	$.ajax({
		type: "POST",
		url: "/admin/lookUp.php",
		data: "action=getBlacklisted",
		dataType: "json",
		success: function(theResponse){
			handleBlackList(theResponse);
		}
	});
	
}

function handleBlackList(theBlackList){
	$.each(theBlackList, function(){
	  theBlacklisted.push(this.featureID);
	});
}

function getCommonSpecial(theClass, theWidth, theType){
	myHTML = "<h4>There is no " + theType + " special for this day</h4>";
	
	return myHTML;
}

function getOppositeID(startID){
	var endID = startID.indexOf("start") >= 0 ? startID.replace("start", "end") : startID.replace("end", "start");
	  
	return endID;
}
	
function tpStartOnHourShowCallback(hour) {
	var endID = getOppositeID($(this).attr("id"));
	
	var tpEndHour = $('#' + endID).timepicker('getHour');
	// all valid if no end time selected
	if ($('#' + endID).val() == '') { return true; }
	// Check if proposed hour is prior or equal to selected end time hour
	if (hour <= tpEndHour) { return true; }
	// if hour did not match, it can not be selected
	return false;
}
  
function tpStartOnMinuteShowCallback(hour, minute) {
	var endID = getOppositeID($(this).attr("id"));
	
	var tpEndHour = $('#' + endID).timepicker('getHour');
	var tpEndMinute = $('#' + endID).timepicker('getMinute');
	// all valid if no end time selected
	if ($('#' + endID).val() == '') { return true; }
	// Check if proposed hour is prior to selected end time hour
	if (hour < tpEndHour) { return true; }
	// Check if proposed hour is equal to selected end time hour and minutes is prior
	if ( (hour == tpEndHour) && (minute < tpEndMinute) ) { return true; }
	// if minute did not match, it can not be selected
	return false;
}
  
function tpEndOnHourShowCallback(hour) {
	var endID = getOppositeID($(this).attr("id"));
	
	var tpStartHour = $('#' + endID).timepicker('getHour');
	// all valid if no start time selected
	if ($('#' + endID).val() == '') { return true; }
	// Check if proposed hour is after or equal to selected start time hour
	if (hour >= tpStartHour) { return true; }
	// if hour did not match, it can not be selected
	return false;
}
function tpEndOnMinuteShowCallback(hour, minute) {
	var endID = getOppositeID($(this).attr("id"));
	
	var tpStartHour = $('#' + endID).timepicker('getHour');
	var tpStartMinute = $('#' + endID).timepicker('getMinute');
	// all valid if no start time selected
	if ($('#' + endID).val() == '') { return true; }
	// Check if proposed hour is after selected start time hour
	if (hour > tpStartHour) { return true; }
	// Check if proposed hour is equal to selected start time hour and minutes is after
	if ( (hour == tpStartHour) && (minute > tpStartMinute) ) { return true; }
	// if minute did not match, it can not be selected
	return false;
}

function removeFirstTag(myContent, startPosition, iteration) {
	var firstTagPos = myContent.indexOf("<", startPosition);
	var firstTagEndPos = myContent.indexOf(">", startPosition + 1);
	
	var myFirstTag = myContent.substring(firstTagPos, firstTagEndPos + 1);
	var myFirstClosingTag = "</" + myFirstTag.substring(1, myFirstTag.length);
	
	var myContentEndPos = myContent.indexOf(myFirstClosingTag, startPosition);
	var myContentTrunc = myContent.substring((firstTagEndPos + 1), myContentEndPos);
	
	
	return myContentTrunc;
}
