<?php
  require('inc/sessionStart.php');
  include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/class.features.inc.php");
  $storeObj = new stores();
  $theLocations = $storeObj->getStoreLocations();
  $locationIDs = array();
  
  foreach($theLocations as $aLocation){
	$locationIDs[] = $aLocation['store_id_share'];
  }
  
  //ONLY ALLOWS A WEBSITE TO ACCESS INFORMATION FOR STORES ASSIGNED TO IT
  $proceed = false;
  if(isset( $_GET['id'])){
	if(in_array($_GET['id'], $locationIDs)){
	  $proceed = true;
	}
  }
  
  if(!$proceed){
	header("Location: storeDetails.php");
  }
?>

<?php
  $pageTitle = "Administration: Edit Store Details";
  $pageDescription = "";
  $pageKeywords = "";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
?>
  <style>
	ul.servicesContainer{
			margin-bottom:15px;
	  }
	  
	  ul.servicesContainer li{
			background-color: #E9E9E9;
			padding:6px;
			list-style: none;
			width:230px;
			margin-bottom:6px;
	  }
	  
	  .removeLI{
			float: right;
	  }
	  
	  .sorter, .makeParent{
			margin-right:6px;
	  }
	  
	  ul.servicesContainer li, .sorter, .removeLI, .makeParent{
			cursor: pointer;
	  }
	  
	  ul.servicesContainer li.parentService{
			background-color:#C0C0C0;
	  }
	  
	  ul.servicesContainer li.childService{
			margin-left:15px;
			width:215px;
	  }
  </style>
  <script src="/Kickstrap/js/jquery-ui-1.9.0.custom.min.js"></script>
  <script src="/Kickstrap/js/jquery.h5validate.js"></script>
  <link href="/Kickstrap/css/smoothness/jquery-ui-1.9.0.custom.css" rel="stylesheet">
  <link href="/Kickstrap/css/jquery.ui.timepicker.css" rel="stylesheet">
  <script src="/Kickstrap/js/jquery.ui.timepicker.js"></script>
	  
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
?>



    
    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
			  <h2>Store Details for <span id="storeNameFill"></span></h2>
			  <div id="returnMessage" class="hideObject"></div>
			  <div id="storeInfo">
				<form action="#" method="post" id="storeInfoForm">
				  <?php include('https://afsshareportal.com/common/storeInfoForm.php'); ?>
				  
				  <h3>Submitter's Information:</h3>
				  <div class="colLeft span6">
						<div class="formEntry span5">
							  <label for="personName">Full Name*:</label>
							  <input type="text" name="personName" id="personName" required>
						</div>
						<div class="formEntry span5">
							  <label for="phoneNum">Phone Number*:</label>
							  <input type="text" name="phoneNum" id="phoneNum" placeholder="123-456-7890" class="h5-phone" data-h5-errorid="phoneNumError" required>
							  <div style="display: none;" class="ui-state-error message theError" id="phoneNumError">Required: Enter a valid phone number.</div>
						</div>
				  </div>
				  <div class="colRight span6">
						<div class="formEntry span5">
							  <label for="personTitle">Job Title*:</label>
							  <input type="text" name="personTitle" id="personTitle" required>
						</div>
						<div class="formEntry span5">
							  <label for="personEmail">Email Address*:</label>
							  <input type="text" name="personEmail" id="personEmail" placeholder="test@abc.com" class="h5-email" data-h5-errorid="emailError" required>
							  <div style="display: none;" class="ui-state-error message theError" id="emailError">Required: Enter a valid email address.</div>
						</div>
				  </div>
				  <input type="submit" value="Update Information" class="btn" id="formSubmit">
				</form>
			  </div>
			</div>
		  </div>
	    </div>
	    
      </section>
      
    </section>
      
    
    
  <script>
   
    
	$("#storeName").parents(".formEntry").remove();
	$(".sectionHeading h3").not(".noRemove").remove();
	
	var storeID = "<?php echo $_GET['id']; ?>";
	
	$("#storeInfoForm").submit(function(e){
	  e.preventDefault();
	  var theData = "action=updateStoreInfo&firstDomain=" + web_URL + "&" + $("#storeInfoForm").serialize();
	  
	  //console.log(theData);
	  
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: theData, 
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallback2"
	  });
	});
	
	function getStoreInfo(){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=storeInfo&storeID=" + storeID,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallback"
	  });
	}
	
	getStoreInfo();
	
	function jsonpcallback2(theResponse){
	  //location.reload();
	  var theMessage = '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">x</a>The store information has been updated.</div>';
	  $("#returnMessage").append(theMessage).removeClass("hideObject");
	  $(window).scrollTop(0);
	  return false; // avoid to execute the actual submit of the form.
	}
	
	function jsonpcallback(theResponse){
		var theHTML = "";
		$.each(theResponse, function(){
		  $(".colRight.span6").append("<input type='hidden' name='storeID' value='" + this.store_id + "'>");
		  $(".colRight.span6").append("<input type='hidden' name='storeName' value='" + this.store_name.replace("'", "_") + "'>");
		  $("#storeNameFill").text(this.store_name);
		  $("#storeAddress").val(this.store_address);
		  $("#storeCity").val(this.store_city);
		  $("#storeZip").val(this.store_zip);
		  $("#storePhoneNum").val(this.store_phone);
		  $("#storePharmPhoneNum").val(this.store_pharmPhone);
		  $("#storeFaxNum").val(this.store_fax);
		  $("#storeYear").val(this.store_year);
		  $("#timepicker_startMon").val(this.store_hMonOpen);
		  $("#timepicker_endMon").val(this.store_hMonClose);
		  $("#timepicker_startSat").val(this.store_hSatOpen);
		  $("#timepicker_endSat").val(this.store_hSatClose);
		  $("#timepicker_startSun").val(this.store_hSunOpen);
		  $("#timepicker_endSun").val(this.store_hSunClose);
		  $("#timepicker_startMonPharm").val(this.store_hMonOpenPharm);
		  $("#timepicker_endMonPharm").val(this.store_hMonClosePharm);
		  $("#timepicker_startSatPharm").val(this.store_hSatOpenPharm);
		  $("#timepicker_endSatPharm").val(this.store_hSatClosePharm);
		  $("#timepicker_startSunPharm").val(this.store_hSunOpenPharm);
		  $("#timepicker_endSunPharm").val(this.store_hSunClosePharm);
		  $("#facebookURL").val(this.store_facebook);
		  $("#twitterHandle").val(this.store_twitter);
		  $("#breakStart option[value='" + this.store_breakStart + "']").prop("selected", true);
		  $("#breakEnd option[value='" + this.store_breakEnd + "']").prop("selected", true);
		  
		  if(this.store_hSunOpen == "Closed"){
			$("#closedSun").click();
		  }
		  
		  if(this.store_hSunOpenPharm == "Closed"){
			$("#closedSunPharm").click();
		  }
		  
		  var theHTML = "";
		  $.each(this.store_services, function(key, parentService){
				//console.log(parentService);
				theHTML += "<ul class='servicesContainer sortable'>";
				$.each(parentService, function(key, aService){
					  
					  var combinedVal = aService.replace(" ", "_");
					  theHTML += "<li><span class='sorter'><i class='icon-reorder'></i></span> <span class='makeParent hideObject' title='Make this item a parent container'><i class='icon-group'></i></span> " + aService;
					  theHTML += "<input type='hidden' value='" + aService + "' name='storeServices[" + combinedVal + "]'>";
					  theHTML += "<span class='removeLI'><i class='icon-remove'></i></span></li>";
				});
				theHTML += "</ul>";
		  });
		  
		  $(".storeServicesContainer").append(theHTML);
		  startSortable();
		  stylizeSortable();
		  initTimepickers();
		});
		
	}
   
    function initTimepickers(){
	
	  $('#timepicker_startMon, #timepicker_startSat, #timepicker_startSun, #timepicker_startMonPharm, #timepicker_startSatPharm, #timepicker_startSunPharm').timepicker({
			showLeadingZero: false,
			onHourShow: tpStartOnHourShowCallback,
			onMinuteShow: tpStartOnMinuteShowCallback,
			showPeriod: true,
	  });
		
	  $('#timepicker_endMon, #timepicker_endSat, #timepicker_endSun, #timepicker_endMonPharm, #timepicker_endSatPharm, #timepicker_endSunPharm').timepicker({
			showLeadingZero: false,
			onHourShow: tpEndOnHourShowCallback,
			onMinuteShow: tpEndOnMinuteShowCallback,
			showPeriod: true,
	  });
	}
	
	
	function getOppositeID(startID){
	  var endID = startID.indexOf("start") >= 0 ? startID.replace("start", "end") : startID.replace("end", "start");
	  
	  return endID;
	}
	
	function tpStartOnHourShowCallback(hour) {
		  var endID = getOppositeID($(this).attr("id"));
		  
		  var tpEndHour = $('#' + endID).timepicker('getHour');
		  // all valid if no end time selected
		  if ($('#' + endID).val() == '') { return true; }
		  // Check if proposed hour is prior or equal to selected end time hour
		  if (hour <= tpEndHour) { return true; }
		  // if hour did not match, it can not be selected
		  return false;
	}
	  
	function tpStartOnMinuteShowCallback(hour, minute) {
		  var endID = getOppositeID($(this).attr("id"));
		  
		  var tpEndHour = $('#' + endID).timepicker('getHour');
		  var tpEndMinute = $('#' + endID).timepicker('getMinute');
		  // all valid if no end time selected
		  if ($('#' + endID).val() == '') { return true; }
		  // Check if proposed hour is prior to selected end time hour
		  if (hour < tpEndHour) { return true; }
		  // Check if proposed hour is equal to selected end time hour and minutes is prior
		  if ( (hour == tpEndHour) && (minute < tpEndMinute) ) { return true; }
		  // if minute did not match, it can not be selected
		  return false;
	}
	  
	function tpEndOnHourShowCallback(hour) {
		  var endID = getOppositeID($(this).attr("id"));
		  
		  var tpStartHour = $('#' + endID).timepicker('getHour');
		  // all valid if no start time selected
		  if ($('#' + endID).val() == '') { return true; }
		  // Check if proposed hour is after or equal to selected start time hour
		  if (hour >= tpStartHour) { return true; }
		  // if hour did not match, it can not be selected
		  return false;
	}
	function tpEndOnMinuteShowCallback(hour, minute) {
		  var endID = getOppositeID($(this).attr("id"));
		  
		  var tpStartHour = $('#' + endID).timepicker('getHour');
		  var tpStartMinute = $('#' + endID).timepicker('getMinute');
		  // all valid if no start time selected
		  if ($('#' + endID).val() == '') { return true; }
		  // Check if proposed hour is after selected start time hour
		  if (hour > tpStartHour) { return true; }
		  // Check if proposed hour is equal to selected start time hour and minutes is after
		  if ( (hour == tpStartHour) && (minute > tpStartMinute) ) { return true; }
		  // if minute did not match, it can not be selected
		  return false;
	}
	  
	  
	  
	  $('#timepicker_startSun, #timepicker_endSun').bind("click", function(){
			$("#closedSun").prop("checked", false);
	  });
	  
	  $("#closedSun").bind("click", function(){
			$('#timepicker_startSun, #timepicker_endSun').val("");
	  });
		
	  $('#timepicker_startSunPharm, #timepicker_endSunPharm').bind("click", function(){
			$("#closedSunPharm").prop("checked", false);
	  });
	  
	  $("#closedSunPharm").bind("click", function(){
			$('#timepicker_startSunPharm, #timepicker_endSunPharm').val("");
	  });
		
	
  </script>

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
