<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Sharegroup Features";
  $pageDescription = "";
  $pageKeywords = "";
?>

  
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
?>

    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
			  <h2>Available Sharegroup Promotions</h2>
			  <div id="sgFeatureContain">
				
			  </div>
			  
			  
			  <div id="oldSGfeatures" class="accordion">
				<h2>Old Sharegroup Promotions <small>Sorted by end date</small></h2>
				<?php
				  for($i = date("Y"); $i >= 2013; $i--){
				?>
				  <div id="year_<?php echo $i; ?>" class="accordion-group">
					<div class="accordion-heading">
					  <h3 class="aYear accordion-toggle" data-toggle="collapse" data-parent="#oldSGfeatures" href="#yearBody_<?php echo $i; ?>"><?php echo $i; ?></h3>
					</div>
					<div class="accordion-body collapse" id="yearBody_<?php echo $i; ?>">
					  <div class="accordion-inner">
					  </div>
					</div>
				  </div>
				<?php }
				?>
			  </div>
			</div>
		  </div>
	    </div>
	    
      </section>
      
    </section>
      
    
  <script src="/admin/js/includeJS.js"></script>
  <script>
    var months = {
	  "01": "January",
	  "02": "February",
	  "03": "March",
	  "04": "April",
	  "05": "May",
	  "06": "June",
	  "07": "July",
	  "08": "August",
	  "09": "September",
	  "10": "October",
	  "11": "November",
	  "12": "December"
	};
    var allFeatures = new Array();
	var theBlacklisted = new Array();
	getBlacklisted();
	
	
	$("body").on("click", ".usingFeature", function(){
	  var $this = $(this);
	  var featureID = $this.parents(".aFeature").attr("id").replace("feature_", "");
	  
	  
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=websiteFeature&website_name=" + web_URL + "&feature_id=" + featureID,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonCallUsingFeature"
	  });
	  
	});
	
	$("body").on("click", ".usingFeatureCommon", function(){
	  var $this = $(this);
	  var featureID = $this.parents(".aFeature").attr("id").replace("feature_", "");
	  
	  $.ajax({
	    type: "POST",
	    url: "interactions.php",
	    data: "action=blacklistFeature&featureID=" + featureID,
	    dataType: "json",
	    success: function(theResponse){
		  //console.log(theResponse);
		  if(theResponse['result'] == true){
			if(theResponse['action'] == "insert"){
			  $this.removeClass("btn-danger").addClass("btn-success").html("Add Feature");
			  $this.parents(".alert").removeClass("alert-success").addClass("alert-error").children(".alertText").html("You are not running this promotion. <br>It is a generic feature that is used for filler when there are not enough features.");
			}else{
			  $this.removeClass("btn-success").addClass("btn-danger").html("Remove Feature");
			  $this.parents(".alert").removeClass("alert-error").addClass("alert-success").children(".alertText").html("You are running this promotion. <br>It is a generic feature that is used for filler when there are not enough features.");
			}
		  }
	    }
      });
	  
	});
	
	function getSGFeatures(){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=allSGfeatures&website_url=" + web_URL + "&store_name=" + store_name + "&sg=" + site_sg,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallback"
	  });
	}
	
	$(".aYear").bind("click", function(){
	  if($(this).attr("id") == "getOldFeatures"){
		var theYear = (new Date).getFullYear();
	  }else{
		var theYear = $(this).parents(".accordion-group").attr("id").replace("year_", "");
	  }
	  
	  var $yearContain = $("#year_" + theYear);
	  
	  if($yearContain.not(".filled").length > 0){
		$.ajax({
		  type: "GET",
		  url: base_site + "lookUpFeatures.php",
		  data: "action=oldSGfeatures&sg=" + site_sg + "&date=" + theYear,
		  dataType: "jsonp",
		  jsonp : "callback",
		  jsonpCallback: "jsonCallOldFeatures" //This is in includeJS.js
		});
	  }
	});
	
	getSGFeatures();
	
	function jsonCallUsingFeature(theResponse){
	  getSGFeatures();
	}
	
	function jsonpcallback(theResponse){
		var theHTML = "";
		var theCount = 0;
		//console.log(theResponse);
		//console.log(theBlacklisted);
		var running = new Array();
		$.each(theResponse.running, function(){
		  //console.log(this.feature_id + ": " + $.inArray(this.feature_id, theBlacklisted));
		  if($.inArray(this.feature_id, theBlacklisted) == -1){
			running.push(this.feature_name.replace(/\\/g, ''));
		  }
		});
		
		$.each(theResponse.all, function(){
		  theHTML += formatFeature(this, running, true);
		  allFeatures.push(this);
		});
		$("#sgFeatureContain").html(theHTML);
		
	}
	
	
	
	
	$("body").on("click", ".duplicateFeat", function(e){
	  e.preventDefault;
	  var sendThis = new Object();
	  var theID = $(this).parents(".aFeature").attr("id").replace("feature_", "");
	  $.each(allFeatures, function(){
		if(this.feature_id == theID){
		  sendThis = this;
		}
	  });
	  sendThis.feature_id = "";
	  sendThis['action'] = "duplicateSGFeature";
	  
	  $.ajax({
	    type: "POST",
	    url: "interactions.php",
	    data: sendThis,
	    dataType: "json",
	    success: function(theResponse){
	      if(theResponse != false){
			window.location = docRoot + "admin/features.php";
		  }
	    },
	    error: function(){
		
	    }
      });
	  
	});
   
  </script>
  

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
