<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Store Features";
  $pageDescription = "";
  $pageKeywords = "";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
?>
<script type="text/javascript" src="/Kickstrap/js/nicEdit.js"></script>
<script src="/Kickstrap/js/jquery-ui-1.9.0.custom.min.js"></script>
<link href="/Kickstrap/css/smoothness/jquery-ui-1.9.0.custom.css" rel="stylesheet">
<link rel="stylesheet" href="//afsshareportal.com/colorbox/colorbox.css" />
<script src="//afsshareportal.com/colorbox/jquery.colorbox.js"></script>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
  require_once('inc/constants.inc.php');
  require_once('inc/class.features.inc.php');
?>


<?php
      if(isset($_GET['id'])){
	    $theFeatureID = $_GET['id'];
	    $addFeature = FALSE;
	    $submitted = TRUE;
	    $stores = new stores();
      }else if(isset($_GET['add'])){
	    $theFeatureID = "";
	    $addFeature = TRUE;
	    $submitted = FALSE;
      }else{
	    if(isset($_GET['show'])){
		  $showFilter = $_GET['show'];
	    }else{
		  $showFilter = "ALL";
	    }
	    $theFeatureID = "";
	    $addFeature = FALSE;
	    $submitted = FALSE;
	    $stores = new stores();
      }
?>
    
    
    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      
	  <section id="fileBrowser" class="hideObject">
	    <div id="browserHolder">
		  <iFrame src="" width="670" height="820" id="theFrame" frameborder="0"></iFrame>
		  <div id="browserCloseContain">
			<p id="browserClose"><i class="icon-remove"></i> Close</p>
		  </div>
	    </div>
	    
      </section>
      <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
				  <div id="noEditError" class="hideObject">
						<div class="alert alert-error">
							  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
						</div>
				  </div>
				  <?php
					if($addFeature === TRUE):
				  ?>
				  <h2>Enter a feature</h2><br>
					<div class="span8">
						  <form method="post" action="interactions.php" name="featureForm" id="featureForm" enctype="multipart/form-data">
							<input type="hidden" name="feature_id" id="feature_id" value="">
							<input type="hidden" name="action" id="action" value="newFeature">
							<table class="addFeature">
							  <?php include("https://afsshareportal.com/common/storeFeatureFormStores.php"); ?>
							</table>
						  </form>
					</div>
				  <?php
					elseif($submitted === TRUE):
						  $theFeature = $stores->getFeature($theFeatureID);
						  $theFeature = $theFeature[0];
						  
						  if(substr($theFeature['feature_photoHor'], 0, 4) != 'http'){
							$newHorizontal = "/" . $theFeature['feature_photoHor'];
						  }else{
							$newHorizontal = $theFeature['feature_photoHor'];
						  }
						  
						  if(substr($theFeature['feature_photoVert'], 0, 4) != 'http'){
							$newVertical = "/" . $theFeature['feature_photoVert'];
						  }else{
							$newVertical = $theFeature['feature_photoVert'];
						  }
						  
						  if(substr($theFeature['feature_photoSquare'], 0, 4) != 'http'){
							$newSquare = "/" . $theFeature['feature_photoSquare'];
						  }else{
							$newSquare = $theFeature['feature_photoSquare'];
						  }
				  ?>
					
					<div class="span7 editFeatureContain">
						  <?php
							  if(isset($_GET['error'])){
						  ?>
						  <p class="alert">
							<a class="close" data-dismiss="alert">x</a>  
						  <?php
							  echo "There was no file in the upload box. Select a file and try again.";
							}
						  ?>
						  </p>
						  <table class="addFeature" id="feature_<?php echo $theFeatureID; ?>">
							<tr>
							  <td class="aLabel">
								Feature Name:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="name_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Feature Name"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><?php echo $theFeature['feature_name']; ?></td>
							</tr>
							<tr>
							  <td class="aLabel">
								Updated By:
							  </td>
							  <td><?php echo $theFeature['feature_update']; ?></td>
							</tr>
							
							<tr>
							  <td class="aLabel">
								Start Date:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="start_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Start Date"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td id="startDate">
								<?php echo stripslashes($theFeature['feature_start']); ?>
							  </td>
							</tr>
							<tr>
							  <td class="aLabel">
								End Date:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="end_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the End Date"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td id="endDate">
								<?php echo $theFeature['feature_end']; ?>
							  </td>
							</tr>
							
							<tr>
							  <td class="aLabel">
								Feature Headline:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="headline_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Headline"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><?php echo stripslashes($theFeature['feature_headline']); ?></td>
							</tr>
							<tr>
							  <td class="aLabel">
								Feature Text:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="text_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Text"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><?php echo stripslashes($theFeature['feature_text']); ?></td>
							</tr>
							<tr class="photo" id="photoHor">
							  <td class="aLabel">
								Photo Horizontal:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="photoHor_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Horizontal Photo"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><img src="<?php echo $newHorizontal; ?>" width="420" alt="Horizontal Picture for <?php echo $theFeature['feature_headline']; ?>"></td>
							</tr>
							<tr class="photo" id="photoVert">
							  <td class="aLabel">
								Photo Vertical:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="photoVert_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Vertical Photo"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><img src="<?php echo $newVertical; ?>" width="175" alt="Vertical Picture for <?php echo $theFeature['feature_headline']; ?>"></td>
							</tr>
							<tr class="photo" id="photoSquare">
							  <td class="aLabel">
								Photo Square:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="photoSquare_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Square Photo"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><img src="<?php echo $newSquare; ?>" width="175" alt="Square Picture for <?php echo $theFeature['feature_headline']; ?>"></td>
							</tr>
							<tr>
							  <td class="aLabel">
								Feature Link:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="link_<?php echo $theFeatureID; ?>"><i class="icon-edit" title="Change the Link"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><?php echo stripslashes($theFeature['feature_link']); ?></td>
							</tr>
						  </table>
					</div>
				  <?php
					else:
				  ?>
					<div id="currentFeatures">
					  <h1>Current Store Features <span class="floatRight"><a href="features.php?add=y" class="btn btn-primary">Add a feature</a></span></h1>
				  <?php
						  $theFeatures = $stores->getFeatures($showFilter);
						  
						  if(count($theFeatures['current']) > 0){
							foreach($theFeatures['current'] as $aFeature){
							  if(substr($aFeature['feature_photoSquare'], 0, 4) != "http"){
									$featPhoto = "/" .$aFeature['feature_photoSquare'];
							  }else{
									$featPhoto = $aFeature['feature_photoSquare'];
							  } 
							
				  ?>
						  <div class="row aFeature clearfix">
							<div class="span7" id="<?php echo $aFeature['feature_id']; ?>">
							  <h2><?php echo stripslashes($aFeature['feature_name']); ?></h2>
							  <div class="clearfix negMargTop">
								<img src="<?php echo $featPhoto; ?>" width="125" height="125" class="featureSquare" alt="Square Picture for <?php echo $aFeature['feature_headline']; ?>">
								<h4><?php echo stripslashes($aFeature['feature_headline']); ?></h4>
								<p class="featureDate"><small><?php echo $aFeature['feature_start']; ?> - <?php echo $aFeature['feature_end']; ?></small></p>
								<p><?php echo stripslashes($aFeature['feature_text']); ?></p>
							  </div>
							  <div>
								<p class="featureControls">
									  <a href="features.php?id=<?php echo $aFeature['feature_id'] ?>"><i class="icon-edit icon-large" title="Edit this feature"></i></a>&nbsp;&nbsp;&nbsp;
									  <a href="#" id="delete<?php echo $aFeature['feature_id']; ?>" class="deleteFeature"><i class="icon-trash icon-large" title="Delete This Feature"></i></a>&nbsp;&nbsp;&nbsp;
									  <a href="#" id="duplicate<?php echo $aFeature['feature_id']; ?>" class="duplicateFeature"><i class="icon-copy icon-large" title="Duplicate this feature"></i></a>&nbsp;&nbsp;&nbsp;
								</p>
							  </div>
							  <div class="deleteAlert alert alert-error hideObject">
									  Are you sure you want to delete this feature?<br><br>
									  <a href="#" class="deleteFeatureConfirm btn">Yes</a> &nbsp;&nbsp;<a href="#" class="deleteFeatureNo btn">No</a>
							  </div>
							</div>
							<div class="span3 storeList"></div>
						  </div>
				  <?php
							}//end foreach($theFeatures['current'] as $aFeature)
						  }//end if(count($theFeatures['current']) > 0)
						  else{
					  ?>
							<h4 class="offsetPadLeft">None</h4>
					  <?php
							}
					 
				  ?>
					</div>
					<div id="futureFeatures">
					  <br><br>
					  <h1>Future Features</h1>
					  <?php
							if(count($theFeatures['future']) > 0){
							  foreach($theFeatures['future'] as $aFeature){
								if(substr($aFeature['feature_photoSquare'], 0, 4) != "http"){
									$featPhoto = "/" .$aFeature['feature_photoSquare'];
								}else{
									$featPhoto = $aFeature['feature_photoSquare'];
								}
							  
					  ?>
							<div class="row aFeature clearfix">
							  <div class="span7" id="<?php echo $aFeature['feature_id']; ?>">
								<h2><?php echo stripslashes($aFeature['feature_name']); ?></h2>
								<div class="clearfix negMargTop">
								  <img src="<?php echo $featPhoto; ?>" width="125" height="125" class="featureSquare" alt="Square Picture for <?php echo $aFeature['feature_headline']; ?>">
								  <h4><?php echo stripslashes($aFeature['feature_headline']); ?></h4>
								  <p class="featureDate"><small><?php echo $aFeature['feature_start']; ?> - <?php echo $aFeature['feature_end']; ?></small></p>
								  <p><?php echo stripslashes($aFeature['feature_text']); ?></p>
								</div>
								<div>
								  <p class="featureControls">
										<a href="features.php?id=<?php echo $aFeature['feature_id'] ?>"><i class="icon-edit icon-large" title="Edit this feature"></i></a>&nbsp;&nbsp;&nbsp;
										<a href="#" id="delete<?php echo $aFeature['feature_id']; ?>" class="deleteFeature"><i class="icon-trash icon-large" title="Delete This Feature"></i></a>&nbsp;&nbsp;&nbsp;
										<a href="#" id="duplicate<?php echo $aFeature['feature_id']; ?>" class="duplicateFeature"><i class="icon-copy icon-large" title="Duplicate this feature"></i></a>&nbsp;&nbsp;&nbsp;
										<a href="#" id="feature<?php echo $aFeature['feature_id']; ?>" class="getFeaturesSites"><i class="icon-search icon-large" title="View Stores Running This Feature"></i></a>&nbsp;&nbsp;&nbsp;
								  </p>
								</div>
								<div class="deleteAlert alert alert-error hideObject">
										Are you sure you want to delete this feature?<br><br>
										<a href="#" class="deleteFeatureConfirm btn">Yes</a> &nbsp;&nbsp;<a href="#" class="deleteFeatureNo btn">No</a>
								</div>
							  </div>
							  <div class="span3 storeList"></div>
							</div>
					  <?php
								  }
							}else{
					  ?>
							<h4 class="offsetPadLeft">None</h4>
					  <?php
							}
					  ?>
					</div>
					
					<div id="oldFeatures" class="accordion">
					  <br><br>
					  <div id="searchContainer">
						<i class="icon-search"></i>
						<input id="autocomplete" size="15"><br><br>
					  </div>
					  <h1>Old Features</h1>
					  <?php
						if(count($theFeatures['old']) > 0){
						  $sortedFeatures = array();
						  
						  foreach($theFeatures['old'] as $feat){
							$theDates = explode("-", $feat['feature_end']);
							$sortedFeatures[$theDates[0]][$theDates[1]][] = $feat;
						  }
						  $sortedFeatures = array_reverse($sortedFeatures, true);
						  
						  foreach($sortedFeatures as $key => $wholeYear){
							$theYear = $key;
					  ?>
							<div id="year_<?php echo $theYear; ?>" class="accordion-group">
							  <div class="accordion-heading">
								<h3 class="aYear accordion-toggle" data-toggle="collapse" data-parent="#oldFeatures" href="#yearBody_<?php echo $theYear; ?>"><?php echo $theYear; ?></h3>
							  </div>
							  <div class="accordion-body collapse" id="yearBody_<?php echo $theYear; ?>">
								<div class="accordion-inner">
					  <?php
							foreach($wholeYear as $aMonth){
							  $theMonth = date("F", strtotime($aMonth[0]['feature_end']));
					  ?>
								<div id="innerAccordion_<?php echo $theYear; ?>_<?php echo $theMonth; ?>" class="accordion">
								  <div class='accordion-group'>
									<div class='accordion-heading'>
									  <h4 class="accordion-toggle" data-toggle="collapse" data-parent="#innerAccordion_<?php echo $theYear; ?>" href="#month_<?php echo $theYear; ?>_<?php echo $theMonth; ?>"><?php echo $theMonth; ?></h4>
									</div>
									<div class="accordion-body collapse" id="month_<?php echo $theYear; ?>_<?php echo $theMonth; ?>">
									  <div class="accordion-inner">
					  
					  <?php
							  foreach($aMonth as $aFeature){
								if(substr($aFeature['feature_photoSquare'], 0, 4) != 'http'){
								  $featPhoto = "/" .$aFeature['feature_photoSquare'];
								}else{
								  $featPhoto = $aFeature['feature_photoSquare'];
								}
					  ?>
								<div class="aFeature clearfix">
								  <div class="span7" id="<?php echo $aFeature['feature_id']; ?>">
									<h2><?php echo stripslashes($aFeature['feature_name']); ?></h2>
									<div class="clearfix negMargTop">
									  <img src="<?php echo $featPhoto ?>" width="125" height="125" class="featureSquare" alt="Square Picture for <?php echo $aFeature['feature_headline']; ?>">
									  <h4><?php echo stripslashes($aFeature['feature_headline']); ?></h4>
									  <p class="featureDate"><small><?php echo $aFeature['feature_start']; ?> - <?php echo $aFeature['feature_end']; ?></small></p>
									  <p><?php echo stripslashes($aFeature['feature_text']); ?></p>
									</div>
									<div>
									  <p class="featureControls">
											<a href="features.php?id=<?php echo $aFeature['feature_id'] ?>"><i class="icon-edit icon-large" title="Edit this feature"></i></a>&nbsp;&nbsp;&nbsp;
											<a href="#" id="delete<?php echo $aFeature['feature_id']; ?>" class="deleteFeature"><i class="icon-trash icon-large" title="Delete This Feature"></i></a>&nbsp;&nbsp;&nbsp;
											<a href="#" id="duplicate<?php echo $aFeature['feature_id']; ?>" class="duplicateFeature"><i class="icon-copy icon-large" title="Duplicate this feature"></i></a>&nbsp;&nbsp;&nbsp;
											<a href="#" id="feature<?php echo $aFeature['feature_id']; ?>" class="getFeaturesSites"><i class="icon-search icon-large" title="View Stores Running This Feature"></i></a>&nbsp;&nbsp;&nbsp;
									  </p>
									</div>
									<div class="deleteAlert alert alert-error hideObject">
											Are you sure you want to delete this feature?<br><br>
											<a href="#" class="deleteFeatureConfirm btn">Yes</a> &nbsp;&nbsp;<a href="#" class="deleteFeatureNo btn">No</a>
									</div>
								  </div>
								</div>
					  <?php
							  }//end foreach($aMonth as $aFeature){
					  ?>
										</div><!--end div.accordion-inner-->
									  </div><!--end div.accordion-body-->
									</div><!--end div.accordion-group-->
								  </div><!-- end div.accordion -->
					  <?php
							}//end foreach($wholeYear as $aMonth){
					  ?>
								  </div><!--end div.accordion-inner-->
								</div><!--end div.accordion-body-->
							  </div><!--end div.accordion-group-->
					  <?php
						  }//end foreach($sortedFeatures as $key => $wholeYear)
						}else{
					  ?>
						  <h4 class="offsetPadLeft">None</h4>
					  <?php
						}
					  ?>
					</div><!--end div.accordion-->
					<br><br>
					<!--<p class="btn" id="oldFeatureShow">See older features</p>-->
				  <?php
					endif; //if submitted == false
				  ?>
			</div>
		  </div>
	    </div>
	    
	    
      </section>
      
    </section>
      
    
      
  <script>
   myAutocompleteFeatures();
   var closeIFrame = function(){
      $("#fileBrowser").addClass("hideObject");
      var theValue = $("#selectedFileIframe").text();
      var theFeature = $("div.span7 table").attr("id").replace("feature_", "");
      var theColumn = $("#theAjaxUpdateDiv").parents("tr.photo").attr("id");
      var theID = theColumn + "_" + theFeature;
      //alert(theFeature + "\n" + theColumn);
      var updateLocation = $("#theAjaxUpdateDiv").siblings("img");
      
      $.ajax({
	    type: "POST",
	    url: "interactions.php",
	    data: "action=updateFeatureValue&column_ID=" + theID + "&value=" + theValue,
	    dataType: "json",
	    success: function(theResponse){
	      
	      $("#theAjaxUpdateDiv").remove();
	      $(updateLocation).attr("src", theValue);
	      
	    },
	    error: function(){
		
	    }
      });
      
   };
   
   
   ks.ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
      
	  $("#oldFeatureShow").on("click", function(){
			var theText = $(this).text() == "See older features" ? "Hide older features" : "See older features";
			
			$(this).text(theText);
			$("#oldFeatures").toggleClass("hideObject");
	  });
	  
      //$(".datepicker").datepicker().on("changeDate", function(ev){$(".dropdown-menu").hide();});
      var nowTemp = new Date();
      var now = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);
      
      var dateStart = $("#datepicker_start1").datepicker({
	    onRender: function(date){
		  //console.log(date.valueOf() < now.valueOf() ? 'disabled' : '');
		  return date.valueOf() < now.valueOf() ? 'disabled' : '';
	    }
      }).on('changeDate', function(ev){
	    if(ev.date.valueOf() > dateEnd.date.valueOf()){
		  var newDate = new Date(ev.date);
		  newDate.setDate(newDate.getDate() + 1);
		  dateEnd.setValue(newDate);
	    }
	    dateStart.hide();
      }).data('datepicker');
      
      var dateEnd = $("#datepicker_end1").datepicker({
	    onRender: function(date){
		  //console.log(date.valuOf + "\n" + now.valueOf);
		  return date.valueOf() <= dateStart.date.valueOf() ? 'disabled' : '';
	    }
      }).on('changeDate', function(ev){
	    dateEnd.hide()
      }).data('datepicker');
      
      
      $(document).ready(function(){
      $("#browserClose").bind("click", function(){
	    $("#fileBrowser").addClass("hideObject");
      });
      
      $("body").on("click", ".existingFile", function(e){
	    e.preventDefault();
	    var theSG = $("#theShargroupName").text();
	    $("#browserHolder iframe").attr("src", "fileBrowser.php?sg=" + theSG);
	    $("#fileBrowser").removeClass("hideObject");
      });
      
      $("#featureForm").find('input[type=text], textarea').val('');
      
      $(".ajaxEdit").bind("click", function(e){
	    e.preventDefault();
	    $("#theAjaxUpdateDiv").remove();
	    var $this = $(this);
	    var theID = $this.attr("id");
	    var theSharegroup = $.trim($("#theShargroupName").text());
	    //var theValue = "This will be the value";
	    
	    var appendHere = $this.parents(".aLabel").siblings();
	    
	    var fullDate = new Date();
	    var thisDay = fullDate.getDate() + "";
	    var thisMonth = fullDate.getMonth() + 1 + "";
	    var thisYear = fullDate.getFullYear();
	    
	    if(thisMonth.length==1)    
		    thisMonth = "0" + thisMonth;
	    
	    if(thisDay.length==1)    
		    thisDay = "0" + thisDay;
	    var todaysDate = thisYear + "-" + thisMonth + "-" + thisDay;
	    
	    
	    var underIndex = theID.indexOf("_");
	    var theColumn = theID.substring(0, underIndex);
	    var featureID = theID.substring(underIndex+1, theID.length);
	    
	    //Create an input based on the value they want to change
	    switch(theColumn){
		  case "name":
			var updateText = "<p>Enter the new Feature Name: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<input type='text' name='newUpdate' id='newUpdate'>";
			break;
		  case "start":
			var updateText = "<p>Pick the new Start Date: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<div id='datepicker_start2' class='input-append date datepicker' data-date-format='yyyy-mm-dd' data-date='" + todaysDate + "'><input type='text' name='newUpdate' id='newUpdate'><span class='add-on'><i class='icon-calendar'></i></span></div>";
			break;
		  case "end":
			var updateText = "<p>Pick the new End Date: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<div id='datepicker_end2' class='input-append date datepicker' data-date-format='yyyy-mm-dd' data-date='" + todaysDate + "'><input type='text' name='newUpdate' id='newUpdate' value='' readonly='readonly'><span class='add-on'><i class='icon-calendar'></i></span></div>";
			break;
		  case "sg":
			var updateText = "<p>Pick the new Sharegroup: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<input type='radio' name='feat_sg' id='feat_sg' value='BVH'> BVH&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_sg' id='feat_sg' value='GYM'> GYM&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_sg' id='feat_sg' value='YHG'> YHG&nbsp;&nbsp;&nbsp;<br><br>";
			break;
	      case "common":
			var updateText = "<p>Is this a Common Feature? <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<input type='radio' name='feat_common' id='feat_common' value='1'> Yes&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_common' id='feat_common' value='0'> No&nbsp;&nbsp;&nbsp;<br><br>";
			break;
		  case "headline":
			var updateText = "<p>Enter the new Headline: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<input type='text' name='newUpdate' id='newUpdate'>";
			break;
		  case "link":
			var updateText = "<p>Enter the new Link: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "http://<input type='text' name='newUpdate' id='newUpdate'>";
			break;
		  case "text":
			var updateText = "<p>Enter the new Text: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			var newInput = "<textarea name='newUpdate' id='newUpdate' rows='6'></textarea>";
			break;
		  case "photoHor":
			var updateText = "<textarea id='photoHorUpdate' name='photoHorUpdate' style='width:100%; height:150px;'></textarea>";
			var newInput = "";
			var photoLoc = "photoHorUpdate";
			break;
		  case "photoVert":
			var updateText = "<textarea id='photoVerUpdate' name='photoVerUpdate' style='width:100%; height:150px;'></textarea>";
			var newInput = "";
			var photoLoc = "photoVerUpdate";
			break;
		  case "photoSquare":
			var updateText = "<textarea id='photoSquUpdate' name='photoSquUpdate' style='width:100%; height:150px;'></textarea>";
			var newInput = "";
			var photoLoc = "photoSquUpdate";
			break;
	    }
	    
	    var theHTML = "";
	    theHTML += "<div id='theAjaxUpdateDiv'>";
	    theHTML += updateText;
	    
	    theHTML += newInput;
	    
	    if(theColumn == "photoHor" || theColumn == "photoVert" || theColumn == "photoSquare"){
		  theHTML += "<br><p><a href='#' id='" + photoLoc + "' class='btn photoUpdateBtn'>Update</a></p>";
		  theHTML += "</form>";  
		}else{
		  theHTML += "<p><a id='newUpdateSubmit' href='#' class='btn'>Update</a></p>";
		}
	    theHTML += "</div>";
	    
	    appendHere.append(theHTML);
	    
		if(theColumn == "photoHor" || theColumn == "photoVert" || theColumn == "photoSquare"){
			//console.log(photoLoc);
			createNicEdit(photoLoc);
		}
		
	    //$("#theAjaxUpdateDiv .datepicker").datepicker();
	    var nowTemp = new Date();
	    var now = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);
	    
	    var dateStart = $("#datepicker_start2").datepicker({
		  onRender: function(date){
			//console.log(date.valueOf() < now.valueOf() ? 'disabled' : '');
			return date.valueOf() < now.valueOf() ? 'disabled' : '';
		  }
	    }).on('changeDate', function(ev){
		  dateStart.hide();
	    }).data('datepicker');
	    
	    var dateEnd = $("#datepicker_end2").datepicker({
		  onRender: function(date){
			//console.log(date.valuOf + "\n" + now.valueOf);
			var sD = $.trim($("#startDate").text()).split('-');
			var theStart = new Date(sD[0], sD[1]-1, sD[2]);
			var startDate = theStart.valueOf();
			return date.valueOf() <= startDate ? 'disabled' : '';
		  }
	    }).on('changeDate', function(ev){
		  dateEnd.hide()
	    }).data('datepicker');
      });
      
      $("body").on("click", "#fakeEndDate", function(e){
	    e.preventDefault();
	    var theFeature = $("div.span7 table").attr("id").replace("feature_", "");
	    $("#endDate").removeClass("text-error");
	    $("#end_" + theFeature).click();
	    $(".alert").remove();
      });
      
	  $("body").on("click", ".photoUpdateBtn", function(e){
			e.preventDefault();
			var $this = $(this);
			var theID = $this.attr("id");
			var theImg = $("#" + theID + "NewContent").find("img").attr("src").replace("/", "");
			if(typeof theImg != "undefined"){
				  //theImg = theImg.substr(0,1) == "/" ? theImg.substr(1, theImg.length) : theImg;
				  //console.log(theImg);
				  
				  var $theParent = $(this).parents("tr");
				  var theID = $(".aLabel span a", $theParent).attr("id");
				  
				  var updateLocation = $(this).parents("tr").children("td")[1];
				  //console.log($updateLocation);
				  var underIndex = theID.indexOf("_");
				  var theColumn = theID.substring(0, underIndex);
				  $.ajax({
						type: "POST",
						url: "interactions.php",
						data: "action=updateFeaturePic&column_ID=" + theID + "&value=" + theImg,
						dataType: "json",
						success: function(theResponse){
							  var updateVal = theResponse['value'];
							  
							  $("#theAjaxUpdateDiv").remove();
							  
							  //$(updateLocation).text(updateVal).addClass("text-success").removeClass('text-error');
							  
							  $("img", updateLocation).attr("src", "/" + updateVal);
							  
							  setTimeout(function(){
									$(updateLocation).removeClass("text-success");
							  }, 2000);
							  
						},
						error: function(){
							
						}
				  });  
			}else{
				  $("#theAjaxUpdateDiv").html("Please choose a file to replace the current file.").addClass("text-error");
				  setTimeout(function(){
						$("#theAjaxUpdateDiv").remove();
				  }, 2000);
			}
	  });
	  
      $("body").on("click", "#newUpdateSubmit", function(e){
	    e.preventDefault();
	    var $theParent = $(this).parents("tr");
	    var theID = $(".aLabel span a", $theParent).attr("id");
	    
	    var updateLocation = $(this).parents("tr").children("td")[1];
	    //console.log($updateLocation);
	    var underIndex = theID.indexOf("_");
	    var theColumn = theID.substring(0, underIndex);
	    
	    if(theColumn == "sg"){
		  //var theValue = $("#feat_sg:checked").val();
		  var theValue = $('input[name="feat_sg"]:checked').val();
	    }else if(theColumn == "common"){
		  //var theValue = $("#feat_common:checked").val();
		  var theValue = $('input[name="feat_common"]:checked').val();
		}else{
		  var theValue = $("#newUpdate").val();  
	    }
	    
	    //THIS IS THE CODE FOR UPDATING ONCE THE VALUE IS DETERMINED
	    $.ajax({
		  type: "POST",
		  url: "interactions.php",
		  data: "action=updateFeatureValue&column_ID=" + theID + "&value=" + theValue,
		  dataType: "json",
		  success: function(theResponse){
		    if(theColumn == "sg"){
				  location.reload();
		    }else if(theColumn == "common"){
				  var updateVal = theResponse['value'] == 1 ? "Yes" : "No";
				  if(updateVal == "Yes"){
						$(".checkBoxes").addClass("hideObject");
				  }else{
						$(".checkBoxes").removeClass("hideObject");
				  }
			}
			else{
				  var updateVal = theResponse['value'];
			}
		    $("#theAjaxUpdateDiv").remove();
		    $(updateLocation).text(updateVal).addClass("text-success").removeClass('text-error');
		    
		    if(theColumn == "start"){
				  var endDate = $.trim($("#endDate").text());
				  var eD = endDate.split('-');
				  var theEnd = new Date(eD[0], eD[1]-1, eD[2]);
				  var theEndValue = theEnd.valueOf();
				  var sD = theResponse['value'].split('-');
				  var theStart = new Date(sD[0], sD[1]-1, sD[2]);
				  var theStartValue = theStart.valueOf();
				  
				  if(theStartValue > theEndValue){
						$("#endDate").addClass("text-error").append("<p class='alert'><a class='close' data-dismiss='alert'>x</a>Your new start date is after your end date. <br><a href='#' id='fakeEndDate'>Click here</a> to edit the end date.</p>");
				  }
		    }
		    
		    setTimeout(function(){
			$(updateLocation).removeClass("text-success");
		    }, 2000);
		  }
	    });
	    
	    
      });
      
      $("body").on("click", "#killAjaxBox", function(e){
	    e.preventDefault();
	    $("#theAjaxUpdateDiv").remove();
      });
      
      $(".deleteFeature").bind("click", function(e){
			e.preventDefault();
			$(this).parents(".span7").children(".deleteAlert").removeClass("hideObject");
	  });
	  
	  $(".deleteFeatureNo").bind("click", function(e){
			e.preventDefault();
			$(this).parents(".deleteAlert").addClass("hideObject");
	  });
	  
	  $("body").on("click", ".deleteFeatureConfirm", function(e){
	    e.preventDefault();
	    var featureID = $(this).parents(".span7").find(".deleteFeature").attr("id").replace("delete", "");
	    $.ajax({
		  type: "POST",
		  url: "interactions.php",
		  data: "action=deleteFeature&feature_id=" + featureID,
		  dataType: "json",
		  success: function(theResponse){
		    //console.log($.type(theResponse));
			//console.log(theResponse);
		    if(theResponse == true){
				  $("#" + featureID).parents(".aFeature").remove();
			}else{
				  $("#noEditErrorText").text("delete a feature")
				  $("#noEditError").removeClass("hideObject");
				  $(document).scrollTop("0");
			}
		  }
	    });
      });
      
      $(".duplicateFeature").bind("click", function(e){
	    e.preventDefault();
	    var featureID = $(this).attr("id").replace("duplicate", "");
	    $.ajax({
		  type: "POST",
		  url: "interactions.php",
		  data: "action=duplicateFeature&feature_id=" + featureID,
		  dataType: "json",
		  success: function(theResponse){
		    //console.log($.type(theResponse));
		    if(theResponse == false){
				  $("#noEditErrorText").text("duplicate a feature")
				  $("#noEditError").removeClass("hideObject");
			}else{
				  window.location ="features.php?id=" + theResponse;
			}
		  }
	    });
      });
      
      $(".getFeaturesSites").bind("click", function(e){
	    e.preventDefault();
	    var featureID = $(this).attr("id").replace("feature", "");
	    var $theStoreList = $(this).parents(".span7").siblings(".storeList");
		var isCommon = $(this).parents(".span7").find("h2 small").text();
		
	    $.ajax({
		  type: "POST",
		  url: "interactions.php",
		  data: "action=getFeatureWebsites&feature_id=" + featureID,
		  dataType: "json",
		  success: function(theResponse){
		    //console.log(theResponse);
		    var theHTML = "<h4>Stores running this promotion:</h4>";
		    if(theResponse != false){
				  $.each(theResponse, function(){
				  theHTML += "<p class='offsetPadLeft'>" + this.website_url + "</p>";
				  });
			}else{
				  //console.log(isCommon);
				  //console.log(isCommon.indexOf("common"));
				  if(isCommon.indexOf("common") >= 0){
						theHTML += "<p class='offsetPadLeft'><b>All sites run this promotion</b></p>";
				  }else{
						theHTML += "<p class='offsetPadLeft'><b>No sites are assigned to this promotion</b></p>";
				  }
			}
		    
		    $theStoreList.html(theHTML);
		  }
	    });
      });
      
      $(".usingFeature").bind("click", function(){
	    var $this = $(this);
	    var websiteID = $this.attr("name");
	    var featureID = $this.parents("table").attr("id");
	    var status = $this.prop('checked');
	    //var theValue = status == "checked" ? 1 : 0;
	    //var theText = status == "checked" ? "now has a website" : "now does not have a website";
	    $.ajax({
		  type: "POST",
		  url: "interactions.php",
		  data: "action=website_feature&website_id=" + websiteID + "&feature_id=" + featureID,
		  success: function(theResponse){
		    $this.parents("tr").addClass("success");
		    setTimeout(function(){
			$this.parents("tr").removeClass("success");
		    }, 2000);
		  },
		  error: function(){
		      $this.parents("tr").addClass("error");
		      setTimeout(function(){
			$this.parents("tr").removeClass("error");
			$this.attr("checked", "");
		      }, 2000);
		  }
	    });
      });
      
      $("#deselectAllStores").bind("click", function(e){
	    e.preventDefault();
	    var theCheckboxes = $(".usingFeature");
	    $.each(theCheckboxes, function(){
		  if($(this).prop("checked") == true){
			$(this).click();
		  }
	    });
      });
      
      $("#selectAllStores").bind("click", function(e){
	    e.preventDefault();
	    var theCheckboxes = $(".usingFeature");
	    $.each(theCheckboxes, function(){
		  if($(this).prop("checked") == false){
			$(this).click();
		  }
	    });
      });
	  
	  function createNicEdit(theLoc){
		//console.log(theLoc);
		new nicEditor({
			fullPanel : false,
			buttonList : ['image', 'upload']
		}).panelInstance(theLoc,{hasPanel : true});	
	  }
   });
      
   });
  </script>
 

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
