<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Running Features";
  $pageDescription = "";
  $pageKeywords = "";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
?>

    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
			  <h2>Current Store Promotions</h2>
			  <div id="storeFeatureContain">
				
			  </div>
			  <h2>Current Sharegroup Promotions</h2>
			  <div id="sgFeatureContain">
				
			  </div>
			  
			</div>
		  </div>
	    </div>
	    
      </section>
      
    </section>
      
    
  <script src="js/includeJS.js"></script>
  <script>
   
    
	$("body").on("click", ".usingFeature", function(){
	  var $this = $(this);
	  var featureID = $this.parents(".aFeature").attr("id").replace("feature_", "");
	  
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=websiteFeature&website_name=" + web_URL + "&feature_id=" + featureID,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonCallUsingFeature"
	  });
	  
	});
	
	function getSGFeatures(){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=allSGfeatures&website_url=" + web_URL + "&sg=" + site_sg,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "jsonpcallback"
	  });
	}
	
	
	$.ajax({
	  type: "POST",
	  url: "interactions.php",
	  //url: "../zSharePortal/lookUpFeatures.php",
	  data: "action=getFeatures",
	  success: function(theResponse){
		var theHTML = "";
		var running = new Array();
		$.each(theResponse, function(){
		  theHTML += formatFeature(this, running, false);
		});
  
		$("#storeFeatureContain").html(theHTML);
	  }
	});
	
	
	
	getSGFeatures();
	
	function jsonCallUsingFeature(theResponse){
	  getSGFeatures()
	}
	
	function jsonpcallback(theResponse){
		var theHTML = "";
		var theCount = 0;
		
		var running = new Array();
		$.each(theResponse.running, function(){
		  running.push(this.feature_name.replace(/\\/g, ''));
		});
		
		$.each(theResponse.all, function(){
		  if($.inArray(this.feature_name.replace(/\\/g, ''), running) >= 0){
			theHTML += formatFeature(this, running, true);
		  }
		});
		$("#sgFeatureContain").html(theHTML);
		
	}
	
	
	
   
   
   $(document).ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
      $(".duplicateFeat").remove();
	  $("#storeFeatureContain img.featureSquare").each(function(){
		var photo = $(this).attr("src");
		if(photo.indexOf("BVH") < 0 && photo.indexOf("GYM") < 0 && photo.indexOf("YHG") < 0){
		  var components = photo.split(".com");
		  var newSrc = components[0] + ".com" + components[1];
		  $(this).attr("src", newSrc);
		}
	  });
   });
  </script>
  

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
