<?php
	//THIS FILE HANDLES ALL OF THE INTERACTIONS WITHIN THE SITE FOR AUTHENTICATED PAGES THAT ARE CALLED THROUGH AJAX
	if(!empty($_POST['action'])){
		$noEncode = array('changeCanEdit', 'changePass', 'deleteUser', 'newFeature', 'duplicateFeature', 'duplicateSGFeature', 'deleteFeature', 'deleteDeliItem','newHotDeal', 'deleteDeal', 'deleteEvent');
		
		$needEncode = true;
		
		if(in_array($_POST['action'], $noEncode)){
			$needEncode = false;
		}
	}
	
	if($needEncode == true){
		header('Content-type: application/json');
	}
	
	require('inc/sessionStart.php');
	require_once('inc/constants.inc.php');
	require_once('inc/class.features.inc.php');
	require_once('inc/class.users.inc.php');
	require_once('inc/class.recipes.inc.php');
	
	
	
	if(!empty($_POST['action'])){
		
		$storeObj = new stores();
		$userObj = new users();
		$recipeObj = new recipes();
		
		$theURL = "none";
		
		switch($_POST['action']){
			case 'getUsers' :
				$update = $userObj->getUsers();
				echo json_encode($update);
				break;
		    case 'changeCanEdit':
				$update = $userObj->changeEdit($_POST['userID'], $_POST['theValue']);
				echo $update;
				break;
			case 'changePass':
				$update = $userObj->changeAPassword($_POST['userID'], $_POST['newPass']);
				echo $update;
				break;
			case 'newUser':
				//var_dump($_POST);
				$update = $userObj->createAccountInAdmin();
				echo json_encode($update);
				break;
		    case 'deleteUser':
				$update = $userObj->deleteUser($_POST['userID']);
				echo $update;
				break;
			case 'blacklistFeature':
				$update = $storeObj->blacklistFeature($_POST['featureID']);
				echo json_encode($update);
				break;
			case 'getFeatures':
				$update = $storeObj->getCurrentFeatures();
				echo json_encode($update);
				break;
			case 'newFeature':
				$update = $storeObj->newFeature();
				$theURL = "features.php?id=" . $update;
				break;
			case "duplicateFeature":
				$update = $storeObj->duplicateFeature($_POST['feature_id']);
				echo $update;
				break;
		    case "duplicateSGFeature":
				$update = $storeObj->duplicateSGFeature();
				$theURL = "features.php?id=" . $update;
				break;
			case "deleteFeature":
				$update = $storeObj->deleteUniversal("feature", $_POST['feature_id']);
				echo $update;
				break;
			case "updateFeatureValue":
				$update = $storeObj->updateFeatureValue($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
			case "updateFeaturePic":
				$update = $storeObj->updateFeatureValue($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
		    case "getLunchDay":
				$update = $storeObj->getLunchDay($_POST['date']);
				echo json_encode($update);
				break;
		    case "updateLunchDay":
				$update = $storeObj->updateLunchDay($_POST['date'], $_POST['deli_id'], $_POST['price'], $_POST['desc'], $_POST['type']);
				echo json_encode($update);
				break;
			case "removeLunchDay":
				$update = $storeObj->removeLunchDay($_POST['date'], $_POST['type']);
				echo json_encode($update);
				break;
		    case "getLunchWeek":
				$update = $storeObj->getLunchWeek($_POST['startDate'], $_POST['endDate']);
				echo json_encode($update);
				break;
			case "newDeliItem":
				$update = $storeObj->addDeliItem($_POST['itemName'], $_POST['lunchPic']);
				echo json_encode($update);
				break;
			case "updateDeliItem":
				$update = $storeObj->updateDeliItem($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
			case "updateDeliPic":
				$update = $storeObj->updateDeliItem($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
			case "deleteDeliItem":
				$update = $storeObj->deleteUniversal("deliItem", $_POST['deli_id']);
				echo $update;
				break;
			case "getFeatureRecipe":
				$info = $recipeObj->getFeaturedRecipe();
				echo json_encode($info);
				break;
			case "setFeatureRecipe":
				$update = $recipeObj->setFeaturedRecipe($_POST['recipeID'], $_POST['recipeName'], $_POST['date']);
				echo json_encode($update);
				break;
			case "removeFeatRecipe":
				$update = $recipeObj->deleteFeaturedRecipe($_POST['date']);
				echo json_encode($update);
				break;
			case "newDirItem":
				$update = $storeObj->newDirItem($_POST['itemName']);
				echo json_encode($update);
				break;
			case "deleteDirItem":
				$update = $storeObj->deleteUniversal("directory", $_POST['itemID']);
				echo json_encode($update);
				break;
			case "newHotDeal":
				$update = $storeObj->newHotDeal();
				
				if($update['result'] == true){
					$theURL = "hotDeals.php?id=" . $update['deal_id'];
				}else{
					$theURL = "hotDeals.php?error=y";
				}
				break;
			case "updateDealValue":
				$update = $storeObj->updateDealValue($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
			case "deleteDeal":
				$update = $storeObj->deleteUniversal("hotDeal", $_POST['deal_id']);
				echo $update;
				break;
			case "deleteEvent":
				$update = $storeObj->deleteUniversal("event", $_POST['event_id']);
				echo $update;
				break;
			case "updateEventValue":
				$update = $storeObj->updateEventValue($_POST['column_ID'], $_POST['value']);
				echo json_encode($update);
				break;
			case "getNoPurchaseEntries":
				$update = $storeObj->getNoPurchaseEntries($_POST['value']);
				echo json_encode($update);
				break;
			default:
				echo "No action sent";
				break;
		}
	}
	
	
	if($theURL != "none"){
?>
	<script>
		var phpURL = '<?php echo $theURL; ?>';
		window.location = phpURL;
	</script>
<?php 
	}
?>
