<?php
/*
* This file creates a table-formatted calendar
*/

function build_calendar($month,$year) {
    $today_date = date("d");
    $today_date = ltrim($today_date, '0');
     // Create array containing abbreviations of days of week.
     $daysOfWeek = array('S','M','T','W','T','F','S');

     // What is the first day of the month in question?
     $firstDayOfMonth = mktime(0,0,0,$month,1,$year);

     // How many days does this month contain?
     $numberDays = date('t',$firstDayOfMonth);

     // Retrieve some information about the first day of the
     // month in question.
     $dateComponents = getdate($firstDayOfMonth);

     // What is the name of the month in question?
     $monthName = $dateComponents['month'];

     // What is the index value (0-6) of the first day of the
     // month in question.
     $dayOfWeek = $dateComponents['wday'];

     // Create the table tag opener and day headers
     
     $refDate = $year . "-" . str_pad($month, 2, "0", STR_PAD_LEFT) . "-01";
     
     $calendar = "<table class='calendar' id='{$refDate}'>";
     $calendar .= "<caption><i class='icon-caret-left floatLeft' id='prevMonth'></i> $monthName $year <i class='icon-caret-right floatRight' id='nextMonth'></i></caption>";
     $calendar .= "<tr>";

     // Create the calendar headers

     foreach($daysOfWeek as $day) {
          $calendar .= "<th class='header'>$day</th>";
     } 

     // Create the rest of the calendar

     // Initiate the day counter, starting with the 1st.

     $currentDay = 1;

     $calendar .= "</tr><tr>";

     // The variable $dayOfWeek is used to
     // ensure that the calendar
     // display consists of exactly 7 columns.

     if ($dayOfWeek > 0) { 
            for($counter = $dayOfWeek; $counter > 0; $counter--){
                $calendar .= "<td class='blankDay'>&nbsp;</td>"; 
            }
     }
     
     $month = str_pad($month, 2, "0", STR_PAD_LEFT);
  
     while ($currentDay <= $numberDays) {

          // Seventh column (Saturday) reached. Start a new row.

          if ($dayOfWeek == 7) {

               $dayOfWeek = 0;
               $calendar .= "</tr><tr>";

          }

          $currentDayRel = str_pad($currentDay, 2, "0", STR_PAD_LEFT);

          $date = "$year-$month-$currentDayRel";
		  
	  if($currentDayRel == $today_date ){  $calendar .= "<td class='day' id='today_date' rel='$date'><b>$currentDay</b></td>"; } 

		  else { $calendar .= "<td class='day' rel='$date'>$currentDay</td>"; }

          // Increment counters

          $currentDay++;
          $dayOfWeek++;

     }

     
     

     // Complete the row of the last week in month, if necessary

     if ($dayOfWeek != 7) { 
     
        $remainingDays = 7 - $dayOfWeek;
        for($aCounter = $remainingDays; $aCounter > 0; $aCounter--){
            $calendar .= "<td class='blankDay'>&nbsp;</td>";
        }

     }
     
     $calendar .= "</tr>";

     $calendar .= "</table>";

     return $calendar;

}

$dateComponents = getdate();

$month = $dateComponents['mon']; 			     
$year = $dateComponents['year'];

echo build_calendar($month,$year);

?>







