<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Hot Deals";
  $pageDescription = "";
  $pageKeywords = "";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php");
?>
  <script async src="//afsshareportal.com/js/moment.min.js"></script>
  <script type="text/javascript" src="/Kickstrap/js/nicEdit.js"></script>
  <link rel="stylesheet" href="//afsshareportal.com/colorbox/colorbox.css" />
  <script src="//afsshareportal.com/colorbox/jquery.colorbox.js"></script>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
  require_once('inc/constants.inc.php');
  require_once('inc/class.features.inc.php');
?>


<?php
      if(isset($_GET['id'])){
	    $theDealID = $_GET['id'];
	    $addFeature = FALSE;
	    $submitted = TRUE;
	    $stores = new stores();
      }else if(isset($_GET['add'])){
	    $theDealID = "";
	    $addFeature = TRUE;
	    $submitted = FALSE;
      }else{
	    if(isset($_GET['show'])){
		  $showFilter = $_GET['show'];
	    }else{
		  $showFilter = "ALL";
	    }
	    $theDealID = "";
	    $addFeature = FALSE;
	    $submitted = FALSE;
	    $stores = new stores();
      }
?>
    
    
    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      
	  <section id="fileBrowser" class="hideObject">
	    <div id="browserHolder">
		  <iFrame src="" width="670" height="820" id="theFrame" frameborder="0"></iFrame>
		  <div id="browserCloseContain">
			<p id="browserClose"><i class="icon-remove"></i> Close</p>
		  </div>
	    </div>
	    
      </section>
      <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
				  <div id="noEditError" class="hideObject">
						<div class="alert alert-error">
							  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
						</div>
				  </div>
				  <?php
					if($addFeature === TRUE):
				  ?>
				  <h2>Upload a Hot Deal</h2><br>
					<div class="span8">
						  <form method="post" action="interactions.php" name="hotDealForm" id="hotDealForm" enctype="multipart/form-data">
							<input type="hidden" name="deal_id" id="deal_id" value="">
							<input type="hidden" name="action" id="action" value="newHotDeal">
							<table class="addFeature">
							  <tr>
								<td><label for="deal_name">Deal Name:</label></td>
								<td><input type="text" name="deal_name" id="deal_name"></td>
							  </tr>
							  <tr>
								<td><label for="datepicker_start">Start Date:</label></td>
								<td  id= "datepicker_start" class="input-append date datepicker" data-date-format="yyyy-mm-dd" data-date="<?php echo date("Y-m-d"); ?>">
									  <input type="text" id="datepicker_start" name="datepicker_start" value="" readonly="readonly" required/>
									  <span class="add-on" id=><i class="icon-calendar"></i></span>
								</td>
							  </tr>
							  <tr>
								<td><label for="datepicker_end">End Date:</label></td>
								<td id= "datepicker_end" class="input-append date datepicker" data-date-format="yyyy-mm-dd" data-date="<?php echo date("Y-m-d"); ?>">
									  <input type="text" id="datepicker_end" name="datepicker_end" value="" readonly="readonly" required/>
									  <span class="add-on" id=><i class="icon-calendar"></i></span>
								</td>
							  </tr>
							  <tr>
								<td><label for="deal_photo">Photo:</label><small>Width < 960px</small></td>
								<td>
								  <textarea id='deal_photoHolder' name='deal_photoHolder' style='width:257px; height:150px;'></textarea>
								  <input type="hidden" name="deal_photo" id="deal_photo" value="">
								</td>
							  </tr>
							  
							  <tr>
								<td colspan="2" style="text-align: right;"><input type="submit" name="send" id="send" class="btn" value="Submit"/></td>
							  </tr>
							</table>
						  </form>
						  
						  <script>
							new nicEditor({
							  fullPanel : false,
							  buttonList : ['image', 'upload']
							}).panelInstance("deal_photoHolder",{hasPanel : true});
						  </script>
					</div>
				  <?php
					elseif($submitted === TRUE):
						  $theFeature = $stores->getHotDeal($theDealID);
				  ?>
					
					<div class="span7 editFeatureContain">
						  <?php
							  if(isset($_GET['error'])){
						  ?>
						  <p class="alert">
							<a class="close" data-dismiss="alert">x</a>  
						  <?php
							  echo "There was no file in the upload box. Select a file and try again.";
							}
						  ?>
						  </p>
						  <table class="addFeature" id="feature_<?php echo $theDealID; ?>">
							<tr>
							  <td class="aLabel">
								Feature Name:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="name_<?php echo $theDealID; ?>"><i class="icon-edit" title="Change the Feature Name"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td><?php echo $theFeature['deal_name']; ?></td>
							</tr>
							<tr>
							  <td class="aLabel">
								Start Date:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="start_<?php echo $theDealID; ?>"><i class="icon-edit" title="Change the Start Date"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td id="startDate">
								<?php echo stripslashes($theFeature['deal_start']); ?>
							  </td>
							</tr>
							<tr>
							  <td class="aLabel">
								End Date:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="end_<?php echo $theDealID; ?>"><i class="icon-edit" title="Change the End Date"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td id="endDate">
								<?php echo $theFeature['deal_end']; ?>
							  </td>
							</tr>
							<tr class="photo" id="photo">
							  <td class="aLabel">
								Photo:
								<span class="featureControls">
									  <a href="#" class="ajaxEdit" id="photo_<?php echo $theDealID; ?>"><i class="icon-edit" title="Change the Photo"></i></a>&nbsp;&nbsp;&nbsp;
								</span>
							  </td>
							  <td>
								<?php
								  if(substr($theFeature['deal_photo'], -3) != "pdf"){
								?>
								  <img src="/<?php echo $theFeature['deal_photo']; ?>" width="420" alt="Photo for <?php echo $theFeature['deal_name']; ?>">
								<?php
								  }//end if(substr($theDeal['deal_photo'], -3) != "pdf")
								  else{
									if(substr($theFeature['deal_photo'], 0, 4) != "http"){
										  $featPhoto = "/" .$theFeature['deal_photo'];
									}else{
										  $featPhoto = $theFeature['deal_photo'];
									}
									if (!is_dir($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic")) {
										mkdir($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic", 0777, true);
									}
									
									$lastSlash = strrpos($featPhoto, "/");
									$fileName = substr($featPhoto, $lastSlash);
									$fileName = str_replace(".pdf", ".jpg", $fileName);
									if(!is_file($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic" . $fileName)){
									  $im = new Imagick($_SERVER['DOCUMENT_ROOT'] . $featPhoto);
									  $im->setIteratorIndex(0);
									  $im->setImageFormat('jpg');
									  $im->setImageCompression(imagick::COMPRESSION_JPEG);
									  $im->setImageCompressionQuality(40);
									  $im->writeImage($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic" . $fileName);
									}
								?>
								  <p><img src="/Kickstrap/img/dynamic<?php echo $fileName; ?>" width="250px" alt="<?php echo $theDeal['deal_name']; ?>"></p>
								<?php
								  }
								?>
							  </td>
							</tr>
						  </table>
					</div>
				  <?php
					else:
				  ?>
					<h1>All Hot Deals <span class="floatRight"><a href="hotDeals.php?add=y" class="btn btn-primary">Add a hot deal</a></span></h1>
				  <?php
						  $theDeals = $stores->getHotDeals($showFilter);
						  
						  foreach($theDeals as $aDeal){
							  if(substr($aDeal['deal_photo'], 0, 4) != "http"){
									$featPhoto = "/" .$aDeal['deal_photo'];
							  }else{
									$featPhoto = $aDeal['deal_photo'];
							  } 
							
				  ?>
						  <div class="row aFeature clearfix">
							<div class="span7" id="<?php echo $aDeal['deal_id']; ?>">
							  <h2><?php echo stripslashes($aDeal['deal_name']); ?></h2>
							  <div class="clearfix negMargTop">
								<?php
								  if(substr($featPhoto, -3) != "pdf"){
								?>
								  <img src="<?php echo $featPhoto; ?>" width="125" class="dealSquare" alt="Photo for <?php echo $aDeal['deal_name']; ?>">
								<?php
								  }//end if(substr($theDeal['deal_photo'], -3) != "pdf")
								  else{
									if (!is_dir($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic")) {
										  mkdir($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic", 0777, true);
									  }
									  
									  $lastSlash = strrpos($featPhoto, "/");
									  $fileName = substr($featPhoto, $lastSlash);
									  $fileName = str_replace(".pdf", ".jpg", $fileName);
									  if(!is_file($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic" . $fileName)){
										$im = new Imagick($_SERVER['DOCUMENT_ROOT'] . $featPhoto);
										$im->setIteratorIndex(0);
										$im->setImageFormat('jpg');
										$im->setImageCompression(imagick::COMPRESSION_JPEG);
										$im->setImageCompressionQuality(40);
										$im->writeImage($_SERVER['DOCUMENT_ROOT'] . "/Kickstrap/img/dynamic" . $fileName);
									  }
								?>
								  <p><img src="/Kickstrap/img/dynamic<?php echo $fileName; ?>" width="250px" alt="<?php echo $theDeal['deal_name']; ?>"></p>
								<?php
								  }
								?>
								<p class="dealDate">
								  <small><?php echo $aDeal['deal_start']; ?> - <?php echo $aDeal['deal_end']; ?></small>
								</p>
								
							  </div>
							  <div>
								<p class="featureControls">
									  <a href="hotDeals.php?id=<?php echo $aDeal['deal_id'] ?>"><i class="icon-edit icon-large" title="Edit this feature"></i></a>&nbsp;&nbsp;&nbsp;
									  <a href="#" id="delete<?php echo $aDeal['deal_id']; ?>" class="deleteFeature"><i class="icon-trash icon-large" title="Delete This Feature"></i></a>&nbsp;&nbsp;&nbsp;
								</p>
							  </div>
							  <div class="deleteAlert alert alert-error hideObject">
									  Are you sure you want to delete this deal?<br><br>
									  <a href="#" class="deleteFeatureConfirm btn">Yes</a> &nbsp;&nbsp;<a href="#" class="deleteFeatureNo btn">No</a>
							  </div>
							</div>
							<div class="span3 storeList"></div>
						  </div>
				  <?php
						  }
				  ?>
					
				  <?php
					endif; //if submitted == false
				  ?>
			</div>
		  </div>
	    </div>
	    
	    
      </section>
      
    </section>
      
    
  <script>
   $(document).ready(function(){	
		$("#hotDealForm").live("submit", function(e){
			//e.preventDefault();
			$("#deal_photo").attr("value", $("#deal_photoHolderNewContent").find("img").attr("src").substring(1));
			return true;
		});
		
		var now = new moment({hour: 0, minute: 0, seconds: 0, milliseconds: 0});
		
		
		if($("#datepicker_start").length){
			setTimeout(function(){
				var dateStart = $("#datepicker_start").datepicker({
				  onRender: function(date){
					//console.log(date.valueOf() < now.valueOf() ? 'disabled' : '');
					return date.valueOf() < now.valueOf() ? 'disabled' : '';
				  }
				}).on('changeDate', function(ev){
				  
				  dateStart.hide();
				}).data('datepicker');
				
				var dateEnd = $("#datepicker_end").datepicker({
				  onRender: function(date){
					//console.log(date);
					//console.log(date.valuOf + "\n" + now.valueOf);
					return date.valueOf() <= dateStart.date.valueOf() ? 'disabled' : '';
				  }
				}).on('changeDate', function(ev){
				  dateEnd.hide()
				}).data('datepicker');
			},1000);
		}
		
		$("td.day.active").removeClass("disabled");
		
		$("#browserClose").bind("click", function(){
		  $("#fileBrowser").addClass("hideObject");
		});
		
		$(".existingFile").live("click", function(e){
		  e.preventDefault();
		  var theSG = $("#theShargroupName").text();
		  $("#browserHolder iframe").attr("src", "fileBrowser.php?sg=" + theSG);
		  $("#fileBrowser").removeClass("hideObject");
		});
		
		$("#featureForm").find('input[type=text], textarea').val('');
		
		$(".ajaxEdit").bind("click", function(e){
		  e.preventDefault();
		  $("#theAjaxUpdateDiv").remove();
		  var $this = $(this);
		  var theID = $this.attr("id");
		  var theSharegroup = $.trim($("#theShargroupName").text());
		  //var theValue = "This will be the value";
		  
		  var appendHere = $this.parents(".aLabel").siblings();
		  
		  var fullDate = new moment();
		  
		  var todaysDate = fullDate.format("YYYY-MM-DD");
		  
		  
		  var underIndex = theID.indexOf("_");
		  var theColumn = theID.substring(0, underIndex);
		  var featureID = theID.substring(underIndex+1, theID.length);
		  
		  //Create an input based on the value they want to change
		  switch(theColumn){
			case "name":
			  var updateText = "<p>Enter the new Feature Name: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<input type='text' name='newUpdate' id='newUpdate'>";
			  break;
			case "start":
			  var updateText = "<p>Pick the new Start Date: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<div id='datepicker_start2' class='input-append date datepicker' data-date-format='yyyy-mm-dd' data-date='" + todaysDate + "'><input type='text' name='newUpdate' id='newUpdate'><span class='add-on'><i class='icon-calendar'></i></span></div>";
			  break;
			case "end":
			  var updateText = "<p>Pick the new End Date: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<div id='datepicker_end2' class='input-append date datepicker' data-date-format='yyyy-mm-dd' data-date='" + todaysDate + "'><input type='text' name='newUpdate' id='newUpdate' value='' readonly='readonly'><span class='add-on'><i class='icon-calendar'></i></span></div>";
			  break;
			case "sg":
			  var updateText = "<p>Pick the new Sharegroup: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<input type='radio' name='feat_sg' id='feat_sg' value='BVH'> BVH&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_sg' id='feat_sg' value='GYM'> GYM&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_sg' id='feat_sg' value='YHG'> YHG&nbsp;&nbsp;&nbsp;<br><br>";
			  break;
			case "common":
			  var updateText = "<p>Is this a Common Feature? <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<input type='radio' name='feat_common' id='feat_common' value='1'> Yes&nbsp;&nbsp;&nbsp;<input type='radio' name='feat_common' id='feat_common' value='0'> No&nbsp;&nbsp;&nbsp;<br><br>";
			  break;
			case "headline":
			  var updateText = "<p>Enter the new Headline: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<input type='text' name='newUpdate' id='newUpdate'>";
			  break;
			case "text":
			  var updateText = "<p>Enter the new Text: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p>";
			  var newInput = "<textarea name='newUpdate' id='newUpdate' rows='6'></textarea>";
			  break;
			case "photo":
			  var updateText = "<p>Pick a new Photo:<br> <textarea id='photoUpdate' name='photoUpdate' style='width:100%; height:150px;'></textarea></p>";
			  case "photo":
			  var newInput = "";
			  var photoLoc = "photoUpdate";
			  break;
			case "photoVert":
			  var updateText = "<p>Pick a new Vertical Photo: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p><br><p><a href='#' class='existingFile'>From uploaded files</a><br>or upload one from your computer <span id='selectedFileIframe' class='hideObject'></span></p>";
			  var newInput = "<input type='file' name='feat_photoVer' id='feat_photoVer'>";
			  break;
			case "photoSquare":
			  var updateText = "<p>Pick a new Square Photo: <span class='floatRight'><a href='#' id='killAjaxBox'><i class='icon-remove'></i></a></span></p><br><p><a href='#' class='existingFile'>From uploaded files</a><br>or upload one from your computer <span id='selectedFileIframe' class='hideObject'></span></p>";
			  var newInput = "<input type='file' name='feat_photoSqu' id='feat_photoSqu'>";
			  break;
		  }
		  
		  var theHTML = "";
		  theHTML += "<div id='theAjaxUpdateDiv'>";
		  theHTML += updateText;
		  
		  theHTML += newInput;
		  
		  if(theColumn == "photo" || theColumn == "photoVert" || theColumn == "photoSquare"){
			theHTML += "<br><p><a href='#' id='" + photoLoc + "' class='btn photoUpdateBtn'>Update</a></p>";
			theHTML += "</form>";  
		  }else{
			theHTML += "<p><a id='newUpdateSubmit' href='#' class='btn'>Update</a></p>";
		  }
		  theHTML += "</div>";
		  
		  appendHere.append(theHTML);
		  
		  if(theColumn == "photo" || theColumn == "photoVert" || theColumn == "photoSquare"){
			  //console.log(photoLoc);
			  createNicEdit(photoLoc);
		  }
		  
		  //$("#theAjaxUpdateDiv .datepicker").datepicker();
		  var now = new moment().set('hour', 0).subtract(1, 'd');
		  
		  if($("#datepicker_start").length || $("#datepicker_start2").length || $("#datepicker_end2").length){
			setTimeout(function(){
				var dateStart = $("#datepicker_start2").datepicker({
				  onRender: function(date){
					//console.log(date.valueOf());
					//console.log(now.valueOf());
					return date.valueOf() < now.valueOf() ? 'disabled' : '';
				  }
				}).on('changeDate', function(ev){
				  dateStart.hide();
				}).data('datepicker');
				
				var dateEnd = $("#datepicker_end2").datepicker({
				  onRender: function(date){
					//console.log(date.valuOf + "\n" + now.valueOf);
					var sD = $.trim($("#startDate").text()).split('-');
					var theStart = new moment(sD[0], (sD[1]-1) + "", sD[2]);
					var startDate = theStart.valueOf();
					return date.valueOf() <= startDate ? 'disabled' : '';
				  }
				}).on('changeDate', function(ev){
				  dateEnd.hide()
				}).data('datepicker');
		  
			},1000);
		  }
		  
		  $("td.day.active").removeClass("disabled");
		});
		
		$("#fakeEndDate").live("click", function(e){
		  e.preventDefault();
		  var theFeature = $("div.span7 table").attr("id").replace("feature_", "");
		  $("#endDate").removeClass("text-error");
		  $("#end_" + theFeature).click();
		  $(".alert").remove();
		});
		
		$(".photoUpdateBtn").live("click", function(e){
			  e.preventDefault();
			  var $this = $(this);
			  var theID = $this.attr("id");
			  var theImg = $("#" + theID + "NewContent").find("img").attr("src").replace("/", "");
			  if(typeof theImg != "undefined"){
					//theImg = theImg.substr(0,1) == "/" ? theImg.substr(1, theImg.length) : theImg;
					//console.log(theImg);
					
					var $theParent = $(this).parents("tr");
					var theID = $(".aLabel span a", $theParent).attr("id");
					
					var updateLocation = $(this).parents("tr").children("td")[1];
					
					var underIndex = theID.indexOf("_");
					var theColumn = theID.substring(0, underIndex);
					$.ajax({
						  type: "POST",
						  url: "interactions.php",
						  data: "action=updateDealValue&column_ID=" + theID + "&value=" + theImg,
						  dataType: "json",
						  success: function(theResponse){
								location.reload();
						  },
						  error: function(){
							  
						  }
					});  
			  }else{
					$("#theAjaxUpdateDiv").html("Please choose a file to replace the current file.").addClass("text-error");
					setTimeout(function(){
						  $("#theAjaxUpdateDiv").remove();
					}, 2000);
			  }
		});
		
		$("#newUpdateSubmit").live("click", function(e){
		  e.preventDefault();
		  var $theParent = $(this).parents("tr");
		  var theID = $(".aLabel span a", $theParent).attr("id");
		  
		  var updateLocation = $(this).parents("tr").children("td")[1];
		  
		  var underIndex = theID.indexOf("_");
		  var theColumn = theID.substring(0, underIndex);
		  
		  if(theColumn == "sg"){
			//var theValue = $("#feat_sg:checked").val();
			var theValue = $('input[name="feat_sg"]:checked').val();
		  }else if(theColumn == "common"){
			//var theValue = $("#feat_common:checked").val();
			var theValue = $('input[name="feat_common"]:checked').val();
		  }else{
			var theValue = $("#newUpdate").val();  
		  }
		  
		  //THIS IS THE CODE FOR UPDATING ONCE THE VALUE IS DETERMINED
		  $.ajax({
			type: "POST",
			url: "interactions.php",
			data: "action=updateDealValue&column_ID=" + theID + "&value=" + theValue,
			dataType: "json",
			success: function(theResponse){
			  if(theColumn == "sg"){
					location.reload();
			  }else if(theColumn == "common"){
					var updateVal = theResponse['value'] == 1 ? "Yes" : "No";
					if(updateVal == "Yes"){
						  $(".checkBoxes").addClass("hideObject");
					}else{
						  $(".checkBoxes").removeClass("hideObject");
					}
			  }
			  else{
					var updateVal = theResponse['value'];
			  }
			  $("#theAjaxUpdateDiv").remove();
			  $(updateLocation).text(updateVal).addClass("text-success").removeClass('text-error');
			  
			  if(theColumn == "start"){
					var endDate = $.trim($("#endDate").text());
					var eD = endDate.split('-');
					var theEnd = new Date(eD[0], eD[1]-1, eD[2]);
					var theEndValue = theEnd.valueOf();
					var sD = theResponse['value'].split('-');
					var theStart = new Date(sD[0], sD[1]-1, sD[2]);
					var theStartValue = theStart.valueOf();
					
					if(theStartValue > theEndValue){
						  $("#endDate").addClass("text-error").append("<p class='alert'><a class='close' data-dismiss='alert'>x</a>Your new start date is after your end date. <br><a href='#' id='fakeEndDate'>Click here</a> to edit the end date.</p>");
					}
			  }
			  
			  setTimeout(function(){
			  $(updateLocation).removeClass("text-success");
			  }, 2000);
			  
			  
			  
			},
			error: function(){
				
			}
		  });
		  
		  
		});
		
		$("#killAjaxBox").live("click", function(e){
		  e.preventDefault();
		  $("#theAjaxUpdateDiv").remove();
		});
		
		$(".deleteFeature").bind("click", function(e){
			  e.preventDefault();
			  $(this).parents(".span7").children(".deleteAlert").removeClass("hideObject");
		});
		
		$(".deleteFeatureNo").bind("click", function(e){
			  e.preventDefault();
			  $(this).parents(".deleteAlert").addClass("hideObject");
		});
		
		$(".deleteFeatureConfirm").live("click", function(e){
		  e.preventDefault();
		  var featureID = $(this).parents(".span7").find(".deleteFeature").attr("id").replace("delete", "");
		  $.ajax({
			type: "POST",
			url: "interactions.php",
			data: "action=deleteDeal&deal_id=" + featureID,
			dataType: "json",
			success: function(theResponse){
			  //console.log($.type(theResponse));
			  //console.log(theResponse);
			  if(theResponse == true){
					$("#" + featureID).parents(".aFeature").remove();
			  }else{
					$("#noEditErrorText").text("delete a feature")
					$("#noEditError").removeClass("hideObject");
					$(document).scrollTop("0");
			  }
			}
		  });
		});
		
		function createNicEdit(theLoc){
		  //console.log(theLoc);
		  new nicEditor({
			  fullPanel : false,
			  buttonList : ['image', 'upload']
		  }).panelInstance(theLoc,{hasPanel : true});	
		}
	});
   
   
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
